/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datatable_autocomplete.data;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.datatable_autocomplete.trie.ITrieConfiguration;
import org.wicketstuff.datatable_autocomplete.tst.TernaryNodeCountingVisitor;
import org.wicketstuff.datatable_autocomplete.tst.TernaryNodeVisitor;
import org.wicketstuff.datatable_autocomplete.tst.TernarySearchTrie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TernarySearchTrieBuilder {
    private static final Logger log = LoggerFactory.getLogger(TernarySearchTrieBuilder.class);
    private Map<String, List<Method>> map = new LinkedHashMap();
    private TernarySearchTrie<Method> trie;

    public TernarySearchTrieBuilder(boolean suffixTrie) {
        this.trie = new TernarySearchTrie((ITrieConfiguration)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void buildTrie(int maxElements) {
        String path = System.getProperty("sun.boot.class.path");
        String[] parts = path.split(":");
        String targetPart = null;
        int addedElements = 0;
        for (String p : parts) {
            if (!p.endsWith("rt.jar")) continue;
            targetPart = p;
            break;
        }
        try {
            JarFile jar = new JarFile(targetPart);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!jarEntry.getName().contains(".class")) continue;
                try {
                    Method[] m;
                    String className = jarEntry.getName().replace("/", ".").replace(".class", "");
                    ClassLoader.getSystemClassLoader().loadClass(className);
                    Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(className);
                    for (Method method : m = clazz.getDeclaredMethods()) {
                        if (!Modifier.isPublic(method.getModifiers())) continue;
                        this.trie.index((Object)method);
                        ++addedElements;
                        String firstCharacter = method.getName().substring(0, 1);
                        LinkedList<Method> methodList = (LinkedList<Method>)this.map.get(firstCharacter);
                        if (methodList == null) {
                            methodList = new LinkedList<Method>();
                            this.map.put(firstCharacter, methodList);
                        }
                        methodList.add(method);
                        if (addedElements < maxElements) continue;
                        log.info("indexed " + addedElements + " elements.");
                        return;
                    }
                }
                catch (ClassNotFoundException e) {
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info("indexed " + addedElements + " elements.");
        this.trie.visit((TernaryNodeVisitor)new TernaryNodeCountingVisitor());
    }

    public List<Method> getListForFirstCharacter(String character) {
        return (List)this.map.get(character);
    }

    public TernarySearchTrie<Method> getTrie() {
        return this.trie;
    }
}

