/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datatable_autocomplete.web.model;

import java.lang.reflect.Method;
import java.util.LinkedList;
import org.apache.wicket.model.IModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadableDetachableMethodModel
implements IModel<Method> {
    private static final long serialVersionUID = 4988788420618189675L;
    private String className = null;
    private String methodName = null;
    private LinkedList<String> methodParameterTypeList = new LinkedList();
    private transient Method transientMethod = null;
    private transient boolean attached = false;

    public LoadableDetachableMethodModel(Method object) {
        this.setObject(object);
    }

    public Method getObject() {
        if (this.attached) {
            return this.transientMethod;
        }
        this.transientMethod = this.load();
        this.attached = true;
        return this.transientMethod;
    }

    public void setObject(Method object) {
        this.attached = true;
        this.transientMethod = object;
        if (object != null) {
            this.className = object.getDeclaringClass().getName();
            this.methodName = object.getName();
        }
    }

    public void detach() {
        this.attached = false;
        this.transientMethod = null;
    }

    private Method load() {
        if (this.className == null) {
            return null;
        }
        Method m = null;
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(this.className);
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().trim().equals(this.methodName.trim())) continue;
                m = method;
                break;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return m;
    }
}

