/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datatable_autocomplete.tree;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import org.apache.commons.collections15.Transformer;
import org.wicketstuff.datatable_autocomplete.trie.TrieNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeVisualizer {
    public TreeVisualizer(String title, DirectedGraph<TrieNode<String>, String> graph) {
        TreeLayout layout = new TreeLayout((Forest)new DelegateForest(graph));
        BasicVisualizationServer vv = new BasicVisualizationServer((Layout)layout);
        vv.setPreferredSize(new Dimension(350, 350));
        vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        vv.getRenderContext().setVertexLabelTransformer((Transformer)new Transformer<TrieNode<String>, String>(){

            public String transform(TrieNode<String> node) {
                return node.getCharacter();
            }
        });
        JFrame frame = new JFrame(title);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)vv);
        frame.pack();
        frame.setVisible(true);
    }
}

