/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datatable_autocomplete.tree;

import edu.uci.ics.jung.algorithms.layout.DAGLayout;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import org.apache.commons.collections15.Transformer;
import org.wicketstuff.datatable_autocomplete.tree.TrieGraph;
import org.wicketstuff.datatable_autocomplete.tree.TrieVisualizerLayout;
import org.wicketstuff.datatable_autocomplete.trie.PatriciaTrie;
import org.wicketstuff.datatable_autocomplete.trie.TrieNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrieVisualizer<T> {
    private TrieGraph<T> graph;

    public TrieVisualizer(String title, TrieGraph<T> graph, TrieVisualizerLayout layoutType) {
        this.graph = graph;
        DAGLayout layout = null;
        switch (layoutType) {
            case TREE: {
                layout = new TreeLayout((Forest)new DelegateForest(graph));
                break;
            }
            case DAG: {
                layout = new DAGLayout(graph);
            }
        }
        VisualizationViewer vv = new VisualizationViewer(layout);
        vv.setPreferredSize(new Dimension(350, 350));
        vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        vv.getRenderContext().setVertexLabelTransformer(new Transformer<TrieNode<T>, String>(){

            public String transform(TrieNode<T> node) {
                return node.getCharacter();
            }
        });
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        gm.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        vv.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        JFrame frame = new JFrame(title);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)vv);
        frame.pack();
        frame.setVisible(true);
    }

    public TrieVisualizer(String title, PatriciaTrie<T> trie, TrieVisualizerLayout layoutType) {
        this(title, new TrieGraph<T>(trie), layoutType);
    }
}

