/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.menu;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.Model;
import org.wicketstuff.menu.IMenuLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Menu
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Model<String> model;
    private final List<IMenuLink> menuItems;
    private boolean visible = true;
    private Component associatedComponent;

    public Menu(Model<String> model, List<IMenuLink> menuItems) {
        if (model == null) {
            throw new IllegalArgumentException("argument [model] cannot be null");
        }
        if (menuItems == null) {
            throw new IllegalArgumentException("argument [menuItems] cannot be null");
        }
        this.model = model;
        this.menuItems = menuItems;
    }

    public Menu(Model<String> model) {
        this(model, new ArrayList<IMenuLink>());
    }

    public Menu addMenuItem(IMenuLink item) {
        this.menuItems.add(item);
        return this;
    }

    public Model<String> getModel() {
        return this.model;
    }

    public List<IMenuLink> getMenuItems() {
        return this.menuItems;
    }

    public Menu setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Menu setAssociatedComponent(Component c) {
        this.associatedComponent = c;
        return this;
    }

    public void redraw(AjaxRequestTarget target) {
        if (this.associatedComponent != null) {
            System.out.println("--- redraw -----------------------------------------------");
            System.out.println("associatedComponent:ID = " + this.associatedComponent.getId());
            System.out.println("associatedComponent:MarkupID = " + this.associatedComponent.getMarkupId());
            System.out.println("getOutputMarkupId() = " + this.associatedComponent.getOutputMarkupId());
            target.addComponent(this.associatedComponent);
        }
    }

    public String toString() {
        return "Menu: " + (String)((Object)this.getModel().getObject()) + " visible = " + this.isVisible();
    }
}

