/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.menu;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.ClientInfo;
import org.wicketstuff.jwicket.IStyleResolver;
import org.wicketstuff.jwicket.JQueryCssResourceReference;
import org.wicketstuff.menu.Menu;
import org.wicketstuff.menu.MenuPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuBarPanel
extends Panel
implements IStyleResolver {
    private static final long serialVersionUID = 1L;
    public static JQueryCssResourceReference[] CSS = new JQueryCssResourceReference[]{new JQueryCssResourceReference(MenuBarPanel.class, "menu.css")};
    protected final List<Menu> menus;
    private static final SimpleAttributeModifier idSingleMenu = new SimpleAttributeModifier("class", (CharSequence)"singleMenu");
    private static final SimpleAttributeModifier idFirstMenu = new SimpleAttributeModifier("class", (CharSequence)"firstMenu");
    private static final SimpleAttributeModifier idMiddleMenu = new SimpleAttributeModifier("class", (CharSequence)"middleMenu");
    private static final SimpleAttributeModifier idLastMenu = new SimpleAttributeModifier("class", (CharSequence)"lastMenu");
    private final WebMarkupContainer menubar;
    private boolean browserDetected = false;
    private boolean browserIsIe56 = false;

    public MenuBarPanel(String id, List<Menu> menus) {
        super(id);
        this.menus = menus;
        this.menubar = new WebMarkupContainer("menubar");
        this.menubar.setOutputMarkupId(true);
        this.add(new Component[]{this.menubar});
    }

    protected void onBeforeRender() {
        if (!this.browserDetected) {
            ClientInfo ci = WebSession.get().getClientInfo();
            if (ci instanceof WebClientInfo) {
                ClientProperties properties = ((WebClientInfo)ci).getProperties();
                if (properties.isBrowserInternetExplorer() && properties.getBrowserVersionMajor() < 7) {
                    this.browserIsIe56 = true;
                }
            } else {
                this.browserIsIe56 = true;
            }
            this.browserDetected = true;
        }
        this.menubar.addOrReplace(new Component[]{new Loop("menus", this.menus.size()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Loop.LoopItem item) {
                int index = item.getIteration();
                Menu menu = MenuBarPanel.this.menus.get(index);
                if (menu.isVisible()) {
                    item.add(new Component[]{new Label("menuTitle", menu.getModel()).setRenderBodyOnly(true)});
                    MenuPanel mp = new MenuPanel("menu", menu.getMenuItems());
                    item.add(new Component[]{mp});
                    mp.setRenderBodyOnly(true);
                    if (index == 0) {
                        if (MenuBarPanel.this.menus.size() == 1) {
                            item.add(new IBehavior[]{idSingleMenu});
                        } else {
                            item.add(new IBehavior[]{idFirstMenu});
                        }
                    } else if (index == MenuBarPanel.this.menus.size() - 1) {
                        item.add(new IBehavior[]{idLastMenu});
                    } else {
                        item.add(new IBehavior[]{idMiddleMenu});
                    }
                } else {
                    item.setVisible(false);
                }
                if (MenuBarPanel.this.browserIsIe56) {
                    item.add(new IBehavior[]{new SimpleAttributeModifier("onmouseover", (CharSequence)"this.className+=' over';")});
                    item.add(new IBehavior[]{new SimpleAttributeModifier("onmouseout", (CharSequence)"this.className=this.className.replace(' over','');")});
                }
                item.setOutputMarkupId(true);
                menu.setAssociatedComponent((Component)item);
            }
        }});
        super.onBeforeRender();
    }

    public void renderHead(HtmlHeaderContainer container) {
        super.renderHead(container);
        JQueryCssResourceReference[] cssResources = this.getCssResources();
        if (cssResources != null) {
            IHeaderResponse headerResponse = container.getHeaderResponse();
            for (JQueryCssResourceReference cssResource : cssResources) {
                headerResponse.renderCSSReference((ResourceReference)cssResource);
            }
        }
    }

    public void refresh(AjaxRequestTarget target) {
        target.addComponent((Component)this.menubar);
    }

    public JQueryCssResourceReference[] getCssResources() {
        return CSS;
    }
}

