/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.menu;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.panel.Panel;
import org.wicketstuff.jwicket.BgIframeBehavior;
import org.wicketstuff.menu.IMenuLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MenuPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final SimpleAttributeModifier disabledMenuItem = new SimpleAttributeModifier("class", (CharSequence)"disabled");
    private List<IMenuLink> menuItems;
    private final WebMarkupContainer menu;

    protected MenuPanel(String id, List<IMenuLink> menuItems) {
        super(id);
        if (menuItems == null) {
            throw new IllegalArgumentException("argument [menuItems] cannot be null");
        }
        this.menuItems = menuItems;
        this.menu = new WebMarkupContainer("menu");
        this.menu.setOutputMarkupId(true);
        this.menu.add(new IBehavior[]{new BgIframeBehavior()});
        this.menu.add(new Component[]{new Loop("items", menuItems.size()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Loop.LoopItem item) {
                AbstractLink link;
                int index = item.getIteration();
                IMenuLink menuItem = (IMenuLink)MenuPanel.this.menuItems.get(index);
                Component linkLabel = menuItem.getDisplayComponent("menuLinkLabel");
                if (linkLabel instanceof Image) {
                    item.add(new Component[]{new WebMarkupContainer("menuLink1").setVisible(false)});
                    link = menuItem.getLink("menuLink2");
                } else {
                    link = menuItem.getLink("menuLink1");
                    item.add(new Component[]{new WebMarkupContainer("menuLink2").setVisible(false)});
                }
                link.setOutputMarkupId(true);
                linkLabel.setOutputMarkupId(true);
                link.add(new Component[]{linkLabel});
                item.add(new Component[]{link});
                if (!link.isEnabled()) {
                    item.add(new IBehavior[]{disabledMenuItem});
                }
                if (!link.isVisible()) {
                    item.setVisible(false);
                }
                item.setOutputMarkupId(true);
            }
        }});
        this.add(new Component[]{this.menu});
    }

    public Component getRedrawComponent() {
        return this.menu;
    }

    public void redraw(AjaxRequestTarget target) {
        target.addComponent((Component)this.menu);
    }
}

