/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.examples;

import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.time.Duration;

public abstract class GMapExampleApplication
extends WebApplication {
    private static final String GOOGLE_MAPS_API_KEY_PARAM = "GoogleMapsAPIkey";

    public static GMapExampleApplication get() {
        WebApplication webApplication = WebApplication.get();
        if (!(webApplication instanceof GMapExampleApplication)) {
            throw new WicketRuntimeException("The application attached to the current thread is not a " + GMapExampleApplication.class.getSimpleName());
        }
        return (GMapExampleApplication)webApplication;
    }

    protected void init() {
        super.init();
        this.getResourceSettings().setResourcePollFrequency(Duration.seconds((int)10));
        this.getMarkupSettings().setStripWicketTags(true);
    }

    public String getGoogleMapsAPIkey() {
        String googleMapsAPIkey = this.getInitParameter(GOOGLE_MAPS_API_KEY_PARAM);
        if (googleMapsAPIkey == null) {
            throw new WicketRuntimeException("There is no Google Maps API key configured in the deployment descriptor of this application.");
        }
        return googleMapsAPIkey;
    }
}

