/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.examples.gmap.refreshpoint;

import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.util.time.Duration;
import wicket.contrib.gmap.GMap2;

public abstract class GMapAutoUpdatingBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final Duration updateInterval;
    private boolean stopped = false;

    public GMapAutoUpdatingBehavior(Duration updateInterval) {
        this.updateInterval = updateInterval;
    }

    protected void onBind() {
        if (!(this.getComponent() instanceof GMap2)) {
            throw new IllegalArgumentException("must be bound to GMap2");
        }
        this.getGMap2().setOutputMarkupId(true);
    }

    protected final GMap2 getGMap2() {
        return (GMap2)this.getComponent();
    }

    public final void stop() {
        this.stopped = true;
    }

    protected void onComponentRendered() {
        if (!this.stopped) {
            Response response = RequestCycle.get().getResponse();
            response.write((CharSequence)"<script type=\"text/javascript\">");
            response.write((CharSequence)this.getJsTimeoutCall(this.updateInterval));
            response.write((CharSequence)"</script>");
        }
    }

    protected final String getJsTimeoutCall(Duration updateInterval) {
        return "window.GmapAutoTimer = setTimeout(\"" + this.getCallbackScript() + "\", " + updateInterval.getMilliseconds() + ");";
    }

    protected final void respond(AjaxRequestTarget target) {
        if (!this.stopped) {
            target.appendJavascript(this.getJsTimeoutCall(this.updateInterval));
        }
        this.onTimer(target, this.getGMap2());
    }

    protected abstract void onTimer(AjaxRequestTarget var1, GMap2 var2);
}

