/*
 * Decompiled with CFR 0.152.
 */
package org.iso_relax.jaxp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import org.iso_relax.verifier.Verifier;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ValidatingDocumentBuilder
extends DocumentBuilder {
    protected DocumentBuilder _WrappedBuilder;
    protected Verifier _Verifier;

    public ValidatingDocumentBuilder(DocumentBuilder wrapped, Verifier verifier) {
        this._WrappedBuilder = wrapped;
        this._Verifier = verifier;
    }

    @Override
    public Document parse(InputSource inputsource) throws SAXException, IOException {
        return this.verify(this._WrappedBuilder.parse(inputsource));
    }

    @Override
    public Document parse(File file) throws SAXException, IOException {
        return this.verify(this._WrappedBuilder.parse(file));
    }

    @Override
    public Document parse(InputStream strm) throws SAXException, IOException {
        return this.verify(this._WrappedBuilder.parse(strm));
    }

    @Override
    public Document parse(InputStream strm, String systemId) throws SAXException, IOException {
        return this.verify(this._WrappedBuilder.parse(strm, systemId));
    }

    @Override
    public Document parse(String url) throws SAXException, IOException {
        return this.verify(this._WrappedBuilder.parse(url));
    }

    @Override
    public boolean isNamespaceAware() {
        return this._WrappedBuilder.isNamespaceAware();
    }

    @Override
    public boolean isValidating() {
        return true;
    }

    @Override
    public void setEntityResolver(EntityResolver entityresolver) {
        this._WrappedBuilder.setEntityResolver(entityresolver);
        this._Verifier.setEntityResolver(entityresolver);
    }

    @Override
    public void setErrorHandler(ErrorHandler errorhandler) {
        this._WrappedBuilder.setErrorHandler(errorhandler);
        this._Verifier.setErrorHandler(errorhandler);
    }

    @Override
    public Document newDocument() {
        return this._WrappedBuilder.newDocument();
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this._WrappedBuilder.getDOMImplementation();
    }

    private Document verify(Document dom) throws SAXException, IOException {
        if (this._Verifier.verify(dom)) {
            return dom;
        }
        throw new SAXException("the document is invalid, but the ErrorHandler does not throw any Exception.");
    }
}

