/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.examples.browser.model;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private File file;

    public FileEntry(File file) {
        this.file = file;
    }

    public boolean isFolder() {
        return this.file.isDirectory();
    }

    public String getSizeAsString() {
        if (this.file.isDirectory()) {
            return "";
        }
        return "" + this.file.length();
    }

    public long getSize() {
        if (this.file.isDirectory()) {
            return 0L;
        }
        return this.file.length();
    }

    public Date lastModified() {
        return new Date(this.file.lastModified());
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public boolean canRead() {
        return this.file.canRead();
    }

    public boolean canWrite() {
        return this.file.canWrite();
    }

    public boolean canExecute() {
        return false;
    }

    public List<FileEntry> getChildren() {
        ArrayList<FileEntry> result = new ArrayList<FileEntry>();
        File[] files = this.file.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isHidden()) continue;
                result.add(new FileEntry(file));
            }
        }
        Collections.sort(result, new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    public String getName() {
        return this.file.getName();
    }
}

