/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.examples.browser.model;

import com.inmethod.grid.examples.browser.model.FileEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTreeNode
implements TreeNode,
Serializable {
    private static final long serialVersionUID = 1L;
    private FileEntry fileEntry;
    private List<FileTreeNode> children = null;
    private FileTreeNode parent;

    FileTreeNode(FileEntry fileEntry, FileTreeNode parent) {
        this.fileEntry = fileEntry;
        this.parent = parent;
    }

    public FileEntry getFileEntry() {
        return this.fileEntry;
    }

    private void ensureChildrenLoaded() {
        if (this.children == null) {
            this.children = new ArrayList();
            List entries = this.fileEntry.getChildren();
            for (FileEntry entry : entries) {
                FileTreeNode node = new FileTreeNode(entry, this);
                this.children.add(node);
            }
        }
    }

    public Enumeration<FileTreeNode> children() {
        this.ensureChildrenLoaded();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.fileEntry.isFolder();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        this.ensureChildrenLoaded();
        return (TreeNode)this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        this.ensureChildrenLoaded();
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        this.ensureChildrenLoaded();
        return this.children.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return !this.fileEntry.isFolder();
    }

    static /* synthetic */ List access$000(FileTreeNode x0) {
        return x0.children;
    }
}

