/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.examples.contact;

import com.inmethod.grid.examples.contact.Contact;
import com.inmethod.grid.examples.contact.ContactGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactsDatabase {
    private Map map = Collections.synchronizedMap(new HashMap());
    private List fnameIdx = Collections.synchronizedList(new ArrayList());
    private List lnameIdx = Collections.synchronizedList(new ArrayList());
    private List fnameDescIdx = Collections.synchronizedList(new ArrayList());
    private List lnameDescIdx = Collections.synchronizedList(new ArrayList());

    public ContactsDatabase(int count) {
        for (int i = 0; i < count; ++i) {
            this.add(ContactGenerator.getInstance().generate());
        }
        this.updateIndices();
    }

    public Contact get(long id) {
        Contact c = (Contact)this.map.get(new Long(id));
        if (c == null) {
            throw new RuntimeException("contact with id [" + id + "] not found in the database");
        }
        return c;
    }

    protected void add(Contact contact) {
        this.map.put(new Long(contact.getId()), contact);
        this.fnameIdx.add(contact);
        this.lnameIdx.add(contact);
        this.fnameDescIdx.add(contact);
        this.lnameDescIdx.add(contact);
    }

    public List<Contact> find(int first, int count, String sortProperty, boolean sortAsc) {
        int last = first + count;
        List index = this.getIndex(sortProperty, sortAsc);
        if (last > index.size()) {
            last = index.size();
        }
        List<Contact> sublist = index.subList(first, last);
        return sublist;
    }

    protected List getIndex(String prop, boolean asc) {
        if (prop == null) {
            return this.fnameIdx;
        }
        if (prop.equals("firstName")) {
            return asc ? this.fnameIdx : this.fnameDescIdx;
        }
        if (prop.equals("lastName")) {
            return asc ? this.lnameIdx : this.lnameDescIdx;
        }
        throw new RuntimeException("uknown sort option [" + prop + "]. valid options: [firstName] , [lastName]");
    }

    public int getCount() {
        return this.fnameIdx.size();
    }

    public void save(Contact contact) {
        if (contact.getId() != 0L) {
            throw new IllegalArgumentException("contact [" + contact.getFirstName() + "] is already persistent");
        }
        contact.setId(ContactGenerator.getInstance().generateId());
        this.add(contact);
        this.updateIndices();
    }

    public void delete(Contact contact) {
        this.map.remove(new Long(contact.getId()));
        this.fnameIdx.remove(contact);
        this.lnameIdx.remove(contact);
        this.fnameDescIdx.remove(contact);
        this.lnameDescIdx.remove(contact);
        contact.setId(0L);
    }

    private void updateIndices() {
        Collections.sort(this.fnameIdx, new /* Unavailable Anonymous Inner Class!! */);
        Collections.sort(this.lnameIdx, new /* Unavailable Anonymous Inner Class!! */);
        Collections.sort(this.fnameDescIdx, new /* Unavailable Anonymous Inner Class!! */);
        Collections.sort(this.lnameDescIdx, new /* Unavailable Anonymous Inner Class!! */);
    }
}

