/*
 * Decompiled with CFR 0.152.
 */
package com.inmethod.grid.examples.pages.datagrid;

import com.inmethod.grid.IDataSource;
import com.inmethod.grid.IGridSortState;
import com.inmethod.grid.examples.contact.Contact;
import com.inmethod.grid.examples.contact.ContactsDatabase;
import com.inmethod.grid.examples.contact.DatabaseLocator;
import com.inmethod.grid.examples.contact.DetachableContactModel;
import java.util.List;
import org.apache.wicket.model.IModel;

public class ContactDataSourceWithUnknownItemCount
implements IDataSource {
    private static final long serialVersionUID = 1L;

    public IModel model(Object object) {
        return new DetachableContactModel((Contact)object);
    }

    public void query(IDataSource.IQuery query, IDataSource.IQueryResult result) {
        ContactsDatabase database = DatabaseLocator.getDatabase();
        String sortProperty = null;
        boolean sortAsc = true;
        if (query.getSortState().getColumns().size() > 0) {
            IGridSortState.ISortStateColumn state = (IGridSortState.ISortStateColumn)query.getSortState().getColumns().get(0);
            sortProperty = state.getPropertyName();
            sortAsc = state.getDirection() == IGridSortState.Direction.ASC;
        }
        List resultList = database.find(query.getFrom(), query.getCount() + 1, sortProperty, sortAsc);
        result.setItems(resultList.iterator());
        if (resultList.size() == query.getCount() + 1) {
            result.setTotalCount(-1);
        } else {
            result.setTotalCount(-2);
        }
    }

    public void detach() {
    }
}

