/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jasperreports.examples;

import java.io.File;
import java.util.HashMap;
import javax.servlet.ServletContext;
import net.sf.jasperreports.engine.JRDataSource;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.link.ResourceLink;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.resource.IResource;
import org.wicketstuff.jasperreports.JRConcreteResource;
import org.wicketstuff.jasperreports.JRImageResource;
import org.wicketstuff.jasperreports.JRResource;
import org.wicketstuff.jasperreports.examples.WebappDataSource;
import org.wicketstuff.jasperreports.handlers.CsvResourceHandler;
import org.wicketstuff.jasperreports.handlers.HtmlResourceHandler;
import org.wicketstuff.jasperreports.handlers.IJRResourceHandler;
import org.wicketstuff.jasperreports.handlers.PdfResourceHandler;
import org.wicketstuff.jasperreports.handlers.RtfResourceHandler;
import org.wicketstuff.jasperreports.handlers.TextResourceHandler;

public class ReportLinksPage
extends WebPage {
    private static final long serialVersionUID = 1L;

    public ReportLinksPage() {
        ServletContext context = ((WebApplication)this.getApplication()).getServletContext();
        File reportFile = new File(context.getRealPath("/reports/WebappReport.jasper"));
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("BaseDir", new File(context.getRealPath("/reports")));
        JRResource pdfResource = new JRConcreteResource(reportFile, (IJRResourceHandler)new PdfResourceHandler()).setReportParameters(parameters).setReportDataSource((JRDataSource)new WebappDataSource());
        this.add(new Component[]{new ResourceLink("linkToPdf", (IResource)pdfResource)});
        JRResource rtfResource = new JRConcreteResource(reportFile, (IJRResourceHandler)new RtfResourceHandler()).setReportParameters(parameters).setReportDataSource((JRDataSource)new WebappDataSource());
        this.add(new Component[]{new ResourceLink("linkToRtf", (IResource)rtfResource)});
        JRResource htmlResource = new JRConcreteResource(reportFile, (IJRResourceHandler)new HtmlResourceHandler()).setReportParameters(parameters).setReportDataSource((JRDataSource)new WebappDataSource());
        this.add(new Component[]{new ResourceLink("linkToHtml", (IResource)htmlResource)});
        JRResource textResource = new JRConcreteResource(reportFile, (IJRResourceHandler)new TextResourceHandler()).setReportParameters(parameters).setReportDataSource((JRDataSource)new WebappDataSource());
        this.add(new Component[]{new ResourceLink("linkToText", (IResource)textResource)});
        JRResource imageResource = new JRImageResource(reportFile).setReportParameters(parameters).setReportDataSource((JRDataSource)new WebappDataSource());
        this.add(new Component[]{new ResourceLink("linkToImage", (IResource)imageResource)});
        JRResource csvResource = new JRConcreteResource(reportFile, (IJRResourceHandler)new CsvResourceHandler()).setReportParameters(parameters).setReportDataSource((JRDataSource)new WebappDataSource());
        this.add(new Component[]{new ResourceLink("linkToCsv", (IResource)csvResource)});
    }

    public boolean isVersioned() {
        return false;
    }
}

