/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.ui.accordion;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.wicketstuff.jwicket.ui.accordion.AccordionBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAccordion<T extends Serializable>
extends Panel {
    private static final long serialVersionUID = 1L;
    protected final WebMarkupContainer accordion;
    protected final AccordionBehavior accordionBehavior;

    public AbstractAccordion(String id, IModel<? extends List<T>> list) {
        this(id, list, -1);
    }

    public AbstractAccordion(String id, IModel<? extends List<T>> list, int expanded) {
        super(id, list);
        ListView repeater = new ListView<T>("repeater", list){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<T> item) {
                WebMarkupContainer headerAnchor = new WebMarkupContainer("headerAnchor");
                headerAnchor.setOutputMarkupId(true);
                headerAnchor.add(new Component[]{AbstractAccordion.this.getHeader("header", item.getModel(), item.getIndex()).setOutputMarkupId(true)});
                item.add(new Component[]{headerAnchor});
                WebMarkupContainer jQueryContentAnchor = new WebMarkupContainer("jQueryContentAnchor");
                jQueryContentAnchor.setOutputMarkupId(true);
                item.add(new Component[]{jQueryContentAnchor});
                WebMarkupContainer contentAnchor = new WebMarkupContainer("contentAnchor");
                contentAnchor.setOutputMarkupId(true);
                contentAnchor.add(new Component[]{AbstractAccordion.this.getContent("content", item.getModel(), item.getIndex()).setOutputMarkupId(true)});
                jQueryContentAnchor.add(new Component[]{contentAnchor});
                item.setRenderBodyOnly(true);
            }
        };
        this.accordion = new WebMarkupContainer("accordion");
        this.accordion.setOutputMarkupId(true);
        this.accordion.setRenderBodyOnly(false);
        this.accordion.add(new Component[]{repeater});
        IBehavior[] iBehaviorArray = new IBehavior[1];
        this.accordionBehavior = this.initAccordionBehavior();
        iBehaviorArray[0] = this.accordionBehavior;
        this.accordion.add(iBehaviorArray);
        if (expanded >= 0) {
            this.getAccordionBehavior().setActive(expanded);
        }
        this.add(new Component[]{this.accordion});
    }

    abstract AccordionBehavior initAccordionBehavior();

    public final AccordionBehavior getAccordionBehavior() {
        return this.accordionBehavior;
    }

    protected abstract Component getHeader(String var1, IModel<T> var2, int var3);

    protected abstract Component getContent(String var1, IModel<T> var2, int var3);

    protected abstract void onExpand(AjaxRequestTarget var1, Component var2, Component var3, int var4);

    protected abstract void onCollapse(AjaxRequestTarget var1, Component var2, Component var3, int var4);

    public int getCurrentExpandedIndex() {
        return this.getAccordionBehavior().getCurrentExpandedIndex();
    }
}

