/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.ui.accordion;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.wicketstuff.jwicket.ui.accordion.AbstractAccordion;
import org.wicketstuff.jwicket.ui.accordion.AccordionBehavior;
import org.wicketstuff.jwicket.ui.accordion.ModelParkingLot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyAccordion<T extends Serializable>
extends AbstractAccordion<T> {
    private static final long serialVersionUID = 1L;

    public LazyAccordion(String id, IModel<? extends List<T>> list) {
        this(id, list, -1);
    }

    public LazyAccordion(String id, IModel<? extends List<T>> list, int expanded) {
        super(id, list, expanded);
        this.getAccordionBehavior().setAutoHeight(false);
        this.getAccordionBehavior().setCollapsible(true);
        this.getAccordionBehavior().setActive(list.getObject() == null ? 0 : ((List)list.getObject()).size() + 1);
    }

    @Override
    protected AccordionBehavior initAccordionBehavior() {
        return new AccordionBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onExpand(AjaxRequestTarget target, Component headerToExpand, Component contentToExpand, int index) {
                Component content;
                Component contentAnchor = ((WebMarkupContainer)contentToExpand).get("contentAnchor");
                if (contentAnchor != null && (content = ((WebMarkupContainer)contentAnchor).get("content")) != null && content instanceof ModelParkingLot) {
                    ModelParkingLot modelParkingLot = (ModelParkingLot)content;
                    ((WebMarkupContainer)contentAnchor).addOrReplace(new Component[]{LazyAccordion.this.getLazyContent("content", modelParkingLot.getModel(), index)});
                    target.addComponent(contentAnchor);
                }
                LazyAccordion.this.onExpand(target, headerToExpand, contentToExpand, index);
            }

            protected void onCollapse(AjaxRequestTarget target, Component headerToExpand, Component contentToExpand, int index) {
                LazyAccordion.this.onCollapse(target, headerToExpand, contentToExpand, index);
            }
        };
    }

    @Override
    protected Component getHeader(String id, IModel<T> t, int tindex) {
        if (t != null) {
            return new Label(id, String.valueOf(t.getObject()));
        }
        return new Label(id, "Header: <null>");
    }

    @Override
    protected Component getContent(String id, IModel<T> t, int tindex) {
        return new ModelParkingLot<T>(id, t);
    }

    protected abstract Component getLazyContent(String var1, IModel<T> var2, int var3);

    @Override
    protected void onExpand(AjaxRequestTarget target, Component headerToExpand, Component contentToExpand, int index) {
    }

    @Override
    protected void onCollapse(AjaxRequestTarget target, Component headerToExpand, Component contentToExpand, int index) {
    }
}

