/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.ui.accordion;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.Request;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.wicketstuff.jwicket.ComponentFinder;
import org.wicketstuff.jwicket.IStyleResolver;
import org.wicketstuff.jwicket.JQueryAjaxBehavior;
import org.wicketstuff.jwicket.JQueryCssResourceReference;
import org.wicketstuff.jwicket.JQueryJavascriptResourceReference;
import org.wicketstuff.jwicket.JQueryResourceReference;
import org.wicketstuff.jwicket.JsMap;
import org.wicketstuff.jwicket.ui.AbstractJqueryUiEmbeddedBehavior;

public class AccordionBehavior
extends AbstractJqueryUiEmbeddedBehavior
implements IStyleResolver {
    private static final long serialVersionUID = 1L;
    public static final JQueryJavascriptResourceReference uiAccordionJs = new JQueryJavascriptResourceReference(AccordionBehavior.class, "jquery.ui.accordion.min.js");
    protected JsMap options = new JsMap();
    private int currentExpandedIndex = -1;

    public AccordionBehavior() {
        super(new JQueryResourceReference[]{AbstractJqueryUiEmbeddedBehavior.jQueryUiWidgetJs, uiAccordionJs});
        this.addCssResources(this.getCssResources());
    }

    public AccordionBehavior setAutoHeight(boolean value) {
        this.options.put((Object)"autoHeight", (Object)value);
        return this;
    }

    public AccordionBehavior setAutoHeight(AjaxRequestTarget target, boolean value) {
        this.setAutoHeight(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').accordion('option','autoHeight'," + value + ");");
        return this;
    }

    public AccordionBehavior setCollapsible(boolean value) {
        this.options.put((Object)"collapsible", (Object)value);
        return this;
    }

    public AccordionBehavior setCollapsible(AjaxRequestTarget target, boolean value) {
        this.setCollapsible(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').accordion('option','collapsible'," + value + ");");
        return this;
    }

    public AccordionBehavior setActive(int value) {
        this.options.put((Object)"active", (Object)value);
        return this;
    }

    public AccordionBehavior setActive(AjaxRequestTarget target, int value) {
        this.setActive(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').accordion('option','active'," + value + ");");
        return this;
    }

    public int getCurrentExpandedIndex() {
        return this.currentExpandedIndex;
    }

    protected void respond(AjaxRequestTarget target) {
        Request request;
        Component component = this.getComponent();
        if (component != null && (request = component.getRequest()) != null) {
            EventType eventType = EventType.stringToType(request.getParameter("wicketAccordionEvent"));
            String newHeader = "";
            String oldHeader = "";
            String newContent = "";
            String oldContent = "";
            String active = "";
            newHeader = request.getParameter("newHeader");
            oldHeader = request.getParameter("oldHeader");
            newContent = request.getParameter("newContent");
            oldContent = request.getParameter("oldContent");
            active = request.getParameter("active");
            int activeIndex = -1;
            try {
                activeIndex = Integer.parseInt(active);
            }
            catch (Exception e) {
                activeIndex = -1;
            }
            if (eventType == EventType.CHANGE) {
                ComponentFinder finder;
                if (oldContent != null && oldHeader != null) {
                    finder = new ComponentFinder(oldHeader);
                    component.getPage().visitChildren((Component.IVisitor)finder);
                    Component oldHeaderComponent = finder.getFoundComponent();
                    finder = new ComponentFinder(oldContent);
                    component.getPage().visitChildren((Component.IVisitor)finder);
                    Component oldContentComponent = finder.getFoundComponent();
                    this.onCollapse(target, oldHeaderComponent, oldContentComponent, this.currentExpandedIndex);
                }
                if (newContent != null && newHeader != null) {
                    finder = new ComponentFinder(newHeader);
                    component.getPage().visitChildren((Component.IVisitor)finder);
                    Component newHeaderComponent = finder.getFoundComponent();
                    finder = new ComponentFinder(newContent);
                    component.getPage().visitChildren((Component.IVisitor)finder);
                    Component newContentComponent = finder.getFoundComponent();
                    if (newHeaderComponent != null && newContentComponent != null) {
                        this.onExpand(target, newHeaderComponent, newContentComponent, activeIndex);
                    }
                    this.currentExpandedIndex = activeIndex;
                } else {
                    this.currentExpandedIndex = -1;
                }
            }
        }
    }

    protected JQueryAjaxBehavior.JsBuilder getJsBuilder() {
        this.options.put((Object)EventType.CHANGE.eventName, (Object)new JQueryAjaxBehavior.JsFunction("function(ev,ui) {var active=jQuery('#" + this.getComponent().getMarkupId() + "').accordion('option', 'active');" + "wicketAjaxGet('" + this.getCallbackUrl() + "&newHeader='+jQuery(ui.newHeader).attr('id')" + "+'&oldHeader='+jQuery(ui.oldHeader).attr('id')" + "+'&newContent='+jQuery(ui.newContent).attr('id')" + "+'&oldContent='+jQuery(ui.oldContent).attr('id')" + "+'&active='+active" + "+'&" + "wicketAccordionEvent" + "=" + EventType.CHANGE + "'" + "); }"));
        JQueryAjaxBehavior.JsBuilder builder = new JQueryAjaxBehavior.JsBuilder();
        builder.append((Object)("jQuery('#" + this.getComponent().getMarkupId() + "').accordion("));
        builder.append((Object)"{");
        builder.append((Object)this.options.toString(this.rawOptions));
        builder.append((Object)"}");
        builder.append((Object)")");
        builder.append((Object)";");
        return builder;
    }

    public JQueryCssResourceReference[] getCssResources() {
        return new JQueryCssResourceReference[]{AbstractJqueryUiEmbeddedBehavior.jQueryUiCss, AbstractJqueryUiEmbeddedBehavior.jQueryUiThemeCss, AbstractJqueryUiEmbeddedBehavior.jQueryUiAccordionCss};
    }

    protected void onExpand(AjaxRequestTarget target, Component headerToExpand, Component contentToExpand, int index) {
    }

    protected void onCollapse(AjaxRequestTarget target, Component headerToExpand, Component contentToExpand, int index) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EventType implements Serializable
    {
        UNKNOWN("*"),
        CHANGE("change"),
        CHANGE_START("changestart");

        public static final String IDENTIFIER = "wicketAccordionEvent";
        private final String eventName;

        private EventType(String eventName) {
            this.eventName = eventName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public static EventType stringToType(String s) {
            for (EventType t : EventType.values()) {
                if (!t.getEventName().equals(s)) continue;
                return t;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.eventName;
        }
    }
}

