/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.ui.datepicker;

import java.io.Serializable;
import java.sql.Date;
import java.text.DateFormat;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.Request;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.FormComponent;
import org.wicketstuff.jwicket.IStyleResolver;
import org.wicketstuff.jwicket.JQueryAjaxBehavior;
import org.wicketstuff.jwicket.JQueryCssResourceReference;
import org.wicketstuff.jwicket.JQueryJavascriptResourceReference;
import org.wicketstuff.jwicket.JQueryResourceReference;
import org.wicketstuff.jwicket.JQuerySpeed;
import org.wicketstuff.jwicket.JsMap;
import org.wicketstuff.jwicket.SpecialKeys;
import org.wicketstuff.jwicket.ui.AbstractJqueryUiEmbeddedBehavior;

public class DatePicker
extends AbstractJqueryUiEmbeddedBehavior
implements IStyleResolver {
    private static final long serialVersionUID = 1L;
    public static final JQueryJavascriptResourceReference uiDatepickerJs = new JQueryJavascriptResourceReference(DatePicker.class, "jquery.ui.datepicker.min.js");
    public static final JQueryJavascriptResourceReference uiDatepickerJs_de = new JQueryJavascriptResourceReference(DatePicker.class, "jquery.ui.datepicker-de.js");
    protected JsMap options = new JsMap();
    private String cssClass = null;
    private boolean onSelectNotificationWanted = false;
    private boolean onCloseNotificationWanted = false;
    private boolean onChangeMonthYearNotificationWanted = false;
    private boolean onBeforeShowDayNotificationWanted = false;
    private boolean onBeforeShowNotificationWanted = false;

    public DatePicker() {
        this(null);
    }

    public DatePicker(ResourceReference icon) {
        super(new JQueryResourceReference[]{SpecialKeys.specialKeysJs, uiDatepickerJs});
        this.addCssResources(this.getCssResources());
        Locale locale = Session.get().getLocale();
        if (locale != null) {
            this.addUserProvidedResourceReferences(new JQueryResourceReference[]{new JQueryJavascriptResourceReference(DatePicker.class, "jquery.ui.datepicker-" + locale.getLanguage() + ".js")});
        }
        if (icon != null) {
            this.setButtonImage(icon);
        }
        this.setRestoreAfterRedraw(true);
    }

    protected void respond(AjaxRequestTarget target) {
        Request request;
        Component component = this.getComponent();
        if (component != null && (request = component.getRequest()) != null) {
            EventType eventType = EventType.stringToType(request.getParameter("wicketDatepickerEvent"));
            if (eventType == EventType.ON_SELECT) {
                String selectedDate = request.getParameter("date");
                SpecialKeys specialKeys = new SpecialKeys(request);
                this.onSelect(target, selectedDate, specialKeys);
                Locale locale = Session.get().getLocale();
                DateFormat df = locale != null ? DateFormat.getDateInstance(2, locale) : DateFormat.getDateInstance(2);
                try {
                    this.onSelect(target, df.parse(selectedDate), specialKeys);
                }
                catch (Exception e) {
                    this.onSelect(target, (java.util.Date)null, specialKeys);
                }
                try {
                    Date date = new Date(df.parse(selectedDate).getTime());
                    this.onSelect(target, date, specialKeys);
                    if (component instanceof FormComponent) {
                        ((FormComponent)component).inputChanged();
                    }
                }
                catch (Exception e) {
                    this.onSelect(target, (Date)null, specialKeys);
                }
            } else if (eventType == EventType.ON_CLOSE) {
                this.onClose(target, request.getParameter("date"), new SpecialKeys(request));
            } else if (eventType == EventType.ON_CHANGE_MONTH_YEAR) {
                this.onChangeMonthYear(target, request.getParameter("year"), request.getParameter("month"), new SpecialKeys(request));
            } else if (eventType == EventType.BEFORE_SHOW_DAY) {
                this.onBeforeShowDay(target, request.getParameter("date"));
            } else if (eventType == EventType.BEFORE_SHOW) {
                this.onBeforeShow(target);
            }
        }
    }

    public DatePicker setAutoSize(boolean value) {
        if (!value) {
            this.options.remove((Object)"autoSize");
        } else {
            this.options.put((Object)"autoSize", (Object)value);
        }
        return this;
    }

    public DatePicker setAutoSize(AjaxRequestTarget target, boolean value) {
        this.setAutoSize(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','autoSize'," + value + ");");
        return this;
    }

    public DatePicker setButtonImage(String value) {
        if (value == null || value.trim().length() == 0) {
            this.options.remove((Object)"buttonImage");
            this.options.remove((Object)"showOn");
        } else {
            this.options.put((Object)"buttonImage", (Object)value);
            this.options.put((Object)"showOn", (Object)"button");
        }
        return this;
    }

    public DatePicker setButtonImage(AjaxRequestTarget target, String value) {
        this.setButtonImage(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','buttonImage','" + (value == null ? "" : value) + "','showOn','button');");
        return this;
    }

    public DatePicker setButtonImage(ResourceReference value) {
        if (value == null) {
            this.options.remove((Object)"buttonImage");
            this.options.remove((Object)"showOn");
        } else {
            this.options.put((Object)"buttonImage", (Object)("resources/" + value.getSharedResourceKey()));
            this.options.put((Object)"showOn", (Object)"button");
        }
        return this;
    }

    public DatePicker setButtonImage(AjaxRequestTarget target, ResourceReference value) {
        this.setButtonImage(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','buttonImage','" + (value == null ? "" : value.getSharedResourceKey()) + "','showOn','button');");
        return this;
    }

    public DatePicker setChangeMonth(boolean value) {
        if (!value) {
            this.options.remove((Object)"changeMonth");
        } else {
            this.options.put((Object)"changeMonth", (Object)value);
        }
        return this;
    }

    public DatePicker setChangeMonth(AjaxRequestTarget target, boolean value) {
        this.setChangeMonth(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','changeMonth'," + value + ");");
        return this;
    }

    public DatePicker setChangeYear(boolean value) {
        if (!value) {
            this.options.remove((Object)"changeYear");
        } else {
            this.options.put((Object)"changeYear", (Object)value);
        }
        return this;
    }

    public DatePicker setChangeYear(AjaxRequestTarget target, boolean value) {
        this.setChangeYear(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','changeYear'," + value + ");");
        return this;
    }

    public DatePicker setCloseText(String value) {
        if (value == null || value.trim().length() == 0) {
            this.options.remove((Object)"closeText");
        } else {
            this.options.put((Object)"closeText", (Object)value);
        }
        return this;
    }

    public DatePicker setCloseText(AjaxRequestTarget target, String value) {
        this.setCloseText(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','closeText','" + value + "');");
        return this;
    }

    public DatePicker setConstraintInput(boolean value) {
        if (!value) {
            this.options.remove((Object)"constraintInput");
        } else {
            this.options.put((Object)"constraintInput", (Object)value);
        }
        return this;
    }

    public DatePicker setConstraintInput(AjaxRequestTarget target, boolean value) {
        this.setConstraintInput(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','constraintInput'," + value + ");");
        return this;
    }

    public DatePicker setCurrentText(String value) {
        if (value == null || value.trim().length() == 0) {
            this.options.remove((Object)"currentText");
        } else {
            this.options.put((Object)"currentText", (Object)value);
        }
        return this;
    }

    public DatePicker setCurrentText(AjaxRequestTarget target, String value) {
        this.setCurrentText(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','currentText','" + value + "');");
        return this;
    }

    public DatePicker setDateFormat(String value) {
        if (value == null || value.trim().length() == 0) {
            this.options.remove((Object)"dateFormat");
        } else {
            this.options.put((Object)"dateFormat", (Object)value);
        }
        return this;
    }

    public DatePicker setDateFormat(AjaxRequestTarget target, String value) {
        this.setDateFormat(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','dateFormat','" + value + "');");
        return this;
    }

    public DatePicker setDate(AjaxRequestTarget target, java.util.Date date) {
        Locale locale = Session.get().getLocale();
        DateFormat df = locale != null ? DateFormat.getDateInstance(2, locale) : DateFormat.getDateInstance(2);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('setDate','" + df.format(date) + "');");
        return this;
    }

    public DatePicker setDuration(String value) {
        if (value == null || value.trim().length() == 0) {
            this.options.remove((Object)"duration");
        } else {
            this.options.put((Object)"duration", (Object)value);
        }
        return this;
    }

    public DatePicker setDuration(AjaxRequestTarget target, String value) {
        this.setDuration(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','duration','" + value + "');");
        return this;
    }

    public DatePicker setDuration(int value) {
        if (value <= 0) {
            this.options.remove((Object)"duration");
        } else {
            this.options.put((Object)"duration", (Object)value);
        }
        return this;
    }

    public DatePicker setDuration(AjaxRequestTarget target, int value) {
        this.setDuration(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','duration'," + value + ");");
        return this;
    }

    public DatePicker setDuration(JQuerySpeed value) {
        if (value == null) {
            this.options.remove((Object)"duration");
        } else {
            this.options.put((Object)"duration", (Object)value.getSpeed());
        }
        return this;
    }

    public DatePicker setDuration(AjaxRequestTarget target, JQuerySpeed value) {
        this.setDuration(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','duration','" + value.getSpeed() + "');");
        return this;
    }

    public DatePicker setMaxDate(String value) {
        if (value == null) {
            this.options.remove((Object)"maxDate");
        } else {
            this.options.put((Object)"maxDate", (Object)value);
        }
        return this;
    }

    public DatePicker setMaxDate(AjaxRequestTarget target, String value) {
        this.setMaxDate(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','maxDate','" + value + "');");
        return this;
    }

    public DatePicker setMaxDate(java.util.Date value) {
        if (value == null) {
            this.options.remove((Object)"maxDate");
        } else {
            Locale locale = Session.get().getLocale();
            DateFormat df = locale != null ? DateFormat.getDateInstance(2, locale) : DateFormat.getDateInstance(2);
            this.options.put((Object)"maxDate", (Object)df.format(value));
        }
        return this;
    }

    public DatePicker setMaxDate(AjaxRequestTarget target, java.util.Date value) {
        this.setMaxDate(value);
        if (value == null) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','maxDate',null);");
        } else {
            Locale locale = Session.get().getLocale();
            DateFormat df = locale != null ? DateFormat.getDateInstance(2, locale) : DateFormat.getDateInstance(2);
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','maxDate','" + df.format(value) + "');");
        }
        return this;
    }

    public DatePicker setMaxDate(Date value) {
        if (value == null) {
            this.options.remove((Object)"maxDate");
        } else {
            Locale locale = Session.get().getLocale();
            DateFormat df = locale != null ? DateFormat.getDateInstance(2, locale) : DateFormat.getDateInstance(2);
            this.options.put((Object)"maxDate", (Object)df.format(value));
        }
        return this;
    }

    public DatePicker setMaxDate(AjaxRequestTarget target, Date value) {
        this.setMaxDate(value);
        if (value == null) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','maxDate',null);");
        } else {
            Locale locale = Session.get().getLocale();
            DateFormat df = locale != null ? DateFormat.getDateInstance(2, locale) : DateFormat.getDateInstance(2);
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','maxDate','" + df.format(value) + "');");
        }
        return this;
    }

    public DatePicker setMinDate(String value) {
        if (value == null) {
            this.options.remove((Object)"minDate");
        } else {
            this.options.put((Object)"minDate", (Object)value);
        }
        return this;
    }

    public DatePicker setMinDate(AjaxRequestTarget target, String value) {
        this.setMinDate(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','minDate','" + value + "');");
        return this;
    }

    public DatePicker setMinDate(java.util.Date value) {
        if (value == null) {
            this.options.remove((Object)"minDate");
        } else {
            Locale locale = Session.get().getLocale();
            DateFormat df = locale != null ? DateFormat.getDateInstance(2, locale) : DateFormat.getDateInstance(2);
            this.options.put((Object)"minDate", (Object)df.format(value));
        }
        return this;
    }

    public DatePicker setMinDate(AjaxRequestTarget target, java.util.Date value) {
        this.setMinDate(value);
        if (value == null) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','minDate',null);");
        } else {
            Locale locale = Session.get().getLocale();
            DateFormat df = locale != null ? DateFormat.getDateInstance(2, locale) : DateFormat.getDateInstance(2);
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','minDate','" + df.format(value) + "');");
        }
        return this;
    }

    public DatePicker setMinDate(Date value) {
        if (value == null) {
            this.options.remove((Object)"minDate");
        } else {
            Locale locale = Session.get().getLocale();
            DateFormat df = locale != null ? DateFormat.getDateInstance(2, locale) : DateFormat.getDateInstance(2);
            this.options.put((Object)"minDate", (Object)df.format(value));
        }
        return this;
    }

    public DatePicker setMinDate(AjaxRequestTarget target, Date value) {
        this.setMinDate(value);
        if (value == null) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','minDate',null);");
        } else {
            Locale locale = Session.get().getLocale();
            DateFormat df = locale != null ? DateFormat.getDateInstance(2, locale) : DateFormat.getDateInstance(2);
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','minDate','" + df.format(value) + "');");
        }
        return this;
    }

    public DatePicker setNumberOfMonths(int value) {
        if (value == 0) {
            this.options.remove((Object)"numberOfMonths");
        } else {
            this.options.put((Object)"numberOfMonths", (Object)value);
        }
        return this;
    }

    public DatePicker setNumberOfMonths(AjaxRequestTarget target, int value) {
        this.setNumberOfMonths(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','numberOfMonths'," + value + ");");
        return this;
    }

    public DatePicker setNumberOfMonths(int rows, int columns) {
        if (rows == 0 || columns == 0) {
            this.options.remove((Object)"numberOfMonths");
        } else {
            this.options.put("numberOfMonths", new Object[]{rows, columns});
        }
        return this;
    }

    public DatePicker setNumberOfMonths(AjaxRequestTarget target, int rows, int columns) {
        this.setNumberOfMonths(rows, columns);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','numberOfMonths',[" + rows + "," + columns + "]);");
        return this;
    }

    public DatePicker setSelectOtherMonths(boolean value) {
        if (!value) {
            this.options.remove((Object)"selectOtherMonths");
        } else {
            this.options.put((Object)"selectOtherMonths", (Object)value);
        }
        return this;
    }

    public DatePicker setSelectOtherMonths(AjaxRequestTarget target, boolean value) {
        this.setSelectOtherMonths(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','selectOtherMonths'," + value + ");");
        return this;
    }

    public DatePicker setShowAnim(ShowAnim value) {
        if (value == null) {
            this.options.remove((Object)"showAnim");
        } else {
            this.options.put((Object)"showAnim", (Object)value.getAnimName());
        }
        return this;
    }

    public DatePicker setShowAnim(AjaxRequestTarget target, ShowAnim value) {
        this.setShowAnim(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','showAnim'," + value.getAnimName() + ");");
        return this;
    }

    public DatePicker setShowButtonPanel(boolean value) {
        if (!value) {
            this.options.remove((Object)"showButtonPanel");
        } else {
            this.options.put((Object)"showButtonPanel", (Object)value);
        }
        return this;
    }

    public DatePicker setShowButtonPanel(AjaxRequestTarget target, boolean value) {
        this.setShowButtonPanel(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','showButtonPanel'," + value + ");");
        return this;
    }

    public DatePicker setShowCurrentAtPos(boolean value) {
        if (!value) {
            this.options.remove((Object)"showCurrentAtPos");
        } else {
            this.options.put((Object)"showCurrentAtPos", (Object)value);
        }
        return this;
    }

    public DatePicker setShowCurrentAtPos(AjaxRequestTarget target, boolean value) {
        this.setShowCurrentAtPos(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','showCurrentAtPos'," + value + ");");
        return this;
    }

    public DatePicker setShowMonthAfterYear(boolean value) {
        if (!value) {
            this.options.remove((Object)"showMonthAfterYear");
        } else {
            this.options.put((Object)"showMonthAfterYear", (Object)value);
        }
        return this;
    }

    public DatePicker setShowMonthAfterYear(AjaxRequestTarget target, boolean value) {
        this.setShowMonthAfterYear(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','showMonthAfterYear'," + value + ");");
        return this;
    }

    public DatePicker setShowOn(ShowOnTrigger value) {
        if (value == null) {
            this.options.remove((Object)"showOn");
        } else {
            this.options.put((Object)"showOn", (Object)value);
        }
        return this;
    }

    public DatePicker setShowOn(AjaxRequestTarget target, ShowOnTrigger value) {
        this.setShowOn(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','showOn','" + value.getTriggerName() + "');");
        return this;
    }

    public DatePicker setShowOtherMonths(boolean value) {
        if (!value) {
            this.options.remove((Object)"showOtherMonths");
        } else {
            this.options.put((Object)"showOtherMonths", (Object)value);
        }
        return this;
    }

    public DatePicker setShowOtherMonths(AjaxRequestTarget target, boolean value) {
        this.setShowOtherMonths(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','showOtherMonths'," + value + ");");
        return this;
    }

    public DatePicker setShowWeek(boolean value) {
        if (!value) {
            this.options.remove((Object)"showWeek");
        } else {
            this.options.put((Object)"showWeek", (Object)value);
        }
        return this;
    }

    public DatePicker setShowWeek(AjaxRequestTarget target, boolean value) {
        this.setShowWeek(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','showWeek'," + value + ");");
        return this;
    }

    public DatePicker setStepMonths(int value) {
        if (value <= 0) {
            this.options.remove((Object)"stepMonths");
        } else {
            this.options.put((Object)"stepMonths", (Object)value);
        }
        return this;
    }

    public DatePicker setStepMonths(AjaxRequestTarget target, int value) {
        this.setStepMonths(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker('option','stepMonths'," + value + ");");
        return this;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public DatePicker setWantOnSelectNotification(boolean value) {
        this.onSelectNotificationWanted = value;
        return this;
    }

    public DatePicker setWantOnCloseNotification(boolean value) {
        this.onCloseNotificationWanted = value;
        return this;
    }

    public DatePicker setWantOnChangeMonthYearNotification(boolean value) {
        this.onChangeMonthYearNotificationWanted = value;
        return this;
    }

    public DatePicker setWantOnBeforeShowDayNotification(boolean value) {
        this.onBeforeShowDayNotificationWanted = value;
        return this;
    }

    public DatePicker setWantOnBeforeShowNotificationWanted(boolean value) {
        this.onBeforeShowNotificationWanted = value;
        return this;
    }

    protected JQueryAjaxBehavior.JsBuilder getJsBuilder() {
        if (this.onBeforeShowNotificationWanted) {
            this.options.put((Object)EventType.BEFORE_SHOW.eventName, (Object)new JQueryAjaxBehavior.JsFunction("function(dateText,inst) { wicketAjaxGet('" + this.getCallbackUrl() + "&" + "wicketDatepickerEvent" + "=" + EventType.BEFORE_SHOW + "&keys='+jQuery.jWicketSpecialKeysGetPressed()" + ");}"));
        } else {
            this.options.remove((Object)EventType.BEFORE_SHOW.getEventName());
        }
        if (this.onSelectNotificationWanted) {
            this.options.put((Object)EventType.ON_SELECT.eventName, (Object)new JQueryAjaxBehavior.JsFunction("function(dateText,inst) { wicketAjaxGet('" + this.getCallbackUrl() + "&date='+dateText" + "+'&" + "wicketDatepickerEvent" + "=" + EventType.ON_SELECT + "&keys='+jQuery.jWicketSpecialKeysGetPressed()" + ");}"));
        } else {
            this.options.remove((Object)EventType.ON_SELECT.getEventName());
        }
        if (this.onCloseNotificationWanted) {
            this.options.put((Object)EventType.ON_CLOSE.eventName, (Object)new JQueryAjaxBehavior.JsFunction("function(dateText,inst) { wicketAjaxGet('" + this.getCallbackUrl() + "&date='+dateText" + "+'&" + "wicketDatepickerEvent" + "=" + EventType.ON_CLOSE + "&keys='+jQuery.jWicketSpecialKeysGetPressed()" + ");}"));
        } else {
            this.options.remove((Object)EventType.ON_CLOSE.getEventName());
        }
        if (this.onChangeMonthYearNotificationWanted) {
            this.options.put((Object)EventType.ON_CHANGE_MONTH_YEAR.eventName, (Object)new JQueryAjaxBehavior.JsFunction("function(year,month,inst) { wicketAjaxGet('" + this.getCallbackUrl() + "&year='+year" + "+'&month='+month" + "+'&" + "wicketDatepickerEvent" + "=" + EventType.ON_CHANGE_MONTH_YEAR + "&keys='+jQuery.jWicketSpecialKeysGetPressed()" + ");}"));
        } else {
            this.options.remove((Object)EventType.ON_CHANGE_MONTH_YEAR.getEventName());
        }
        if (this.onBeforeShowDayNotificationWanted) {
            this.options.put((Object)EventType.BEFORE_SHOW_DAY.eventName, (Object)new JQueryAjaxBehavior.JsFunction("function(date) { wicketAjaxGet('" + this.getCallbackUrl() + "&date='+date" + "+'&" + "wicketDatepickerEvent" + "=" + EventType.BEFORE_SHOW_DAY + "&keys='+jQuery.jWicketSpecialKeysGetPressed()" + ");return new Array(true, '','');}"));
        } else {
            this.options.remove((Object)EventType.BEFORE_SHOW_DAY.getEventName());
        }
        JQueryAjaxBehavior.JsBuilder builder = new JQueryAjaxBehavior.JsBuilder();
        if (this.isAlreadyRendered()) {
            builder.append((Object)("jQuery('#" + this.getComponent().getMarkupId() + "+button').remove();"));
        }
        builder.append((Object)("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker("));
        builder.append((Object)"{");
        builder.append((Object)this.options.toString(this.rawOptions));
        builder.append((Object)"}");
        builder.append((Object)")");
        if (this.cssClass != null) {
            builder.append((Object)";jQuery('#ui-datepicker-div').wrap('<div class=\"");
            builder.append((Object)this.cssClass);
            builder.append((Object)"\" />')");
        }
        return builder;
    }

    protected void onBeforeShow(AjaxRequestTarget target) {
    }

    protected void onSelect(AjaxRequestTarget target, String pickedDate, SpecialKeys specialKeys) {
    }

    protected void onSelect(AjaxRequestTarget target, java.util.Date pickedDate, SpecialKeys specialKeys) {
    }

    protected void onSelect(AjaxRequestTarget target, Date pickedDate, SpecialKeys specialKeys) {
    }

    protected void onClose(AjaxRequestTarget target, String pickedDate, SpecialKeys specialKeys) {
    }

    protected void onChangeMonthYear(AjaxRequestTarget target, String year, String month, SpecialKeys specialKeys) {
    }

    @Deprecated
    protected String onBeforeShowDay(AjaxRequestTarget target, String date) {
        return "";
    }

    public void disable(AjaxRequestTarget target) {
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker( 'disable' );");
        target.addComponent(this.getComponent());
    }

    public void enable(AjaxRequestTarget target) {
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').datepicker( 'enable' );");
        target.appendJavascript(this.getJsBuilder().toString());
    }

    public JQueryCssResourceReference[] getCssResources() {
        return new JQueryCssResourceReference[]{AbstractJqueryUiEmbeddedBehavior.jQueryUiBaseCss, AbstractJqueryUiEmbeddedBehavior.jQueryUiThemeCss};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShowOnTrigger implements Serializable
    {
        FOCUS("focus"),
        BUTTON("button"),
        BOTH("both");

        private final String triggerName;

        private ShowOnTrigger(String triggerName) {
            this.triggerName = triggerName;
        }

        public String getTriggerName() {
            return this.triggerName;
        }

        public String toString() {
            return this.triggerName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShowAnim implements Serializable
    {
        SHOW("show"),
        SLIDE_DOWN("slideSown"),
        FADE_IN("fadeIn");

        private final String animName;

        private ShowAnim(String animName) {
            this.animName = animName;
        }

        public String getAnimName() {
            return this.animName;
        }

        public String toString() {
            return this.animName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EventType implements Serializable
    {
        UNKNOWN("*"),
        BEFORE_SHOW("beforeShow"),
        BEFORE_SHOW_DAY("beforeShowDay"),
        ON_CHANGE_MONTH_YEAR("onChangeMonthYear"),
        ON_CLOSE("onClose"),
        ON_SELECT("onSelect");

        public static final String IDENTIFIER = "wicketDatepickerEvent";
        private final String eventName;

        private EventType(String eventName) {
            this.eventName = eventName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public static EventType stringToType(String s) {
            for (EventType t : EventType.values()) {
                if (!t.getEventName().equals(s)) continue;
                return t;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.eventName;
        }
    }
}

