/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.ui.effect;

import org.wicketstuff.jwicket.JQueryJavascriptResourceReference;
import org.wicketstuff.jwicket.ui.effect.AbstractJqueryUiEffect;

public class Scale
extends AbstractJqueryUiEffect {
    private static final long serialVersionUID = 1L;
    public static final JQueryJavascriptResourceReference jQueryUiEffectsScaleJs = new JQueryJavascriptResourceReference(Scale.class, "jquery.effects.scale.min.js");
    private String direction = null;
    private String from = null;
    private String percent = null;
    private String scale = null;

    public Scale() {
        super(jQueryUiEffectsScaleJs);
    }

    String getEffectName() {
        return "scale";
    }

    public Scale setDirection(ScaleDirection value) {
        this.direction = value == null ? null : value.getDirection();
        return this;
    }

    public Scale setFrom(int height, int width) {
        this.from = height < 0 || width < 0 ? null : "{height:" + height + ",width:" + width + "}";
        return this;
    }

    public Scale setPercen(int value) {
        this.percent = value <= 0 ? null : String.valueOf(value);
        return this;
    }

    public Scale setElement(ScaleElement value) {
        this.scale = value == null ? null : value.getElement();
        return this;
    }

    void appendOptions(StringBuilder jsString) {
        if (this.direction != null || this.from != null || this.percent != null || this.scale != null) {
            boolean firstOption = true;
            jsString.append(",{");
            if (this.direction != null) {
                jsString.append("direction:'");
                jsString.append(this.direction);
                jsString.append("'");
                firstOption = false;
            }
            if (this.from != null) {
                if (!firstOption) {
                    jsString.append(",");
                }
                jsString.append("from:");
                jsString.append(this.from);
                firstOption = false;
            }
            if (this.percent != null) {
                if (!firstOption) {
                    jsString.append(",");
                }
                jsString.append("percent:");
                jsString.append(this.percent);
                firstOption = false;
            }
            if (this.scale != null) {
                if (!firstOption) {
                    jsString.append(",");
                }
                jsString.append("scale:'");
                jsString.append(this.scale);
                jsString.append("'");
            }
            jsString.append("}");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScaleElement {
        DEFAULT(null),
        BOTH("both"),
        BOX("box"),
        CONTENT("content");

        private final String direction;

        private ScaleElement(String direction) {
            this.direction = direction;
        }

        public String getElement() {
            return this.direction;
        }

        public String toString() {
            return this.direction == null ? "default" : this.direction;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScaleDirection {
        DEFAULT(null),
        BOTH("both"),
        VERTICAL("vertical"),
        HORIZONTAL("horizontal");

        private final String direction;

        private ScaleDirection(String direction) {
            this.direction = direction;
        }

        public String getDirection() {
            return this.direction;
        }

        public String toString() {
            return this.direction == null ? "default" : this.direction;
        }
    }
}

