/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.ui.resizable;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.Request;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.wicketstuff.jwicket.JQueryAjaxBehavior;
import org.wicketstuff.jwicket.JQueryJavascriptResourceReference;
import org.wicketstuff.jwicket.JQueryResourceReference;
import org.wicketstuff.jwicket.JsMap;
import org.wicketstuff.jwicket.SpecialKeys;
import org.wicketstuff.jwicket.ui.AbstractJqueryUiEmbeddedBehavior;
import org.wicketstuff.jwicket.ui.resizable.IResizable;

public class ResizableBehavior
extends AbstractJqueryUiEmbeddedBehavior {
    private static final long serialVersionUID = 1L;
    public static final JQueryJavascriptResourceReference uiResizableJs = new JQueryJavascriptResourceReference(ResizableBehavior.class, "jquery.ui.resizable.min.js");
    protected JsMap options = new JsMap();
    private boolean onResizeStartNotificationWanted = false;
    private boolean onResizeNotificationWanted = false;

    public ResizableBehavior() {
        super(new JQueryResourceReference[]{AbstractJqueryUiEmbeddedBehavior.jQueryUiWidgetJs, AbstractJqueryUiEmbeddedBehavior.jQueryUiMouseJs, SpecialKeys.specialKeysJs, uiResizableJs});
    }

    protected void respond(AjaxRequestTarget target) {
        Request request;
        Component component = this.getComponent();
        if (component != null && (request = component.getRequest()) != null) {
            EventType eventType = EventType.stringToType(request.getParameter("wicketResizeEvent"));
            int top = 0;
            int left = 0;
            int width = 0;
            int height = 0;
            int originalTop = 0;
            int originalLeft = 0;
            int originalWidth = 0;
            int originalHeight = 0;
            try {
                top = Integer.parseInt(request.getParameter("top"));
                left = Integer.parseInt(request.getParameter("left"));
                width = (int)(Double.parseDouble(request.getParameter("width")) + 0.5);
                height = (int)(Double.parseDouble(request.getParameter("height")) + 0.5);
                if (eventType == EventType.RESIZE_END) {
                    originalTop = Integer.parseInt(request.getParameter("originalTop"));
                    originalLeft = Integer.parseInt(request.getParameter("originalLeft"));
                    originalWidth = (int)(Double.parseDouble(request.getParameter("originalWidth")) + 0.5);
                    originalHeight = (int)(Double.parseDouble(request.getParameter("originalHeight")) + 0.5);
                }
            }
            catch (Exception e) {
                throw new WicketRuntimeException((Throwable)e);
            }
            if (component instanceof IResizable) {
                IResizable resizableComponent = (IResizable)component;
                if (eventType == EventType.RESIZE_END) {
                    resizableComponent.onResized(target, top, left, width, height, originalTop, originalLeft, originalWidth, originalHeight, new SpecialKeys(request));
                } else if (eventType == EventType.RESIZE_START) {
                    resizableComponent.onResizeStart(target, top, left, width, height, new SpecialKeys(request));
                } else if (eventType == EventType.RESIZE) {
                    resizableComponent.onResize(target, top, left, width, height, new SpecialKeys(request));
                }
            }
            if (eventType == EventType.RESIZE_END) {
                this.onResized(target, top, left, width, height, originalTop, originalLeft, originalWidth, originalHeight, new SpecialKeys(request));
            } else if (eventType == EventType.RESIZE_START) {
                this.onResizeStart(target, top, left, width, height, new SpecialKeys(request));
            } else if (eventType == EventType.RESIZE) {
                this.onResize(target, top, left, width, height, new SpecialKeys(request));
            }
        }
    }

    public ResizableBehavior setAnimate(boolean value) {
        if (!value) {
            this.options.remove((Object)"animate");
        } else {
            this.options.put((Object)"animate", (Object)value);
        }
        return this;
    }

    public ResizableBehavior setAnimate(AjaxRequestTarget target, boolean value) {
        this.setAnimate(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','animate'," + value + ");");
        return this;
    }

    public ResizableBehavior setAnimateDuration(int value) {
        if (value <= 0) {
            this.options.remove((Object)"animateDuration");
        } else {
            this.options.put((Object)"animateDuration", (Object)value);
        }
        return this;
    }

    public ResizableBehavior setAnimateDuration(AjaxRequestTarget target, int value) {
        this.setAnimateDuration(value);
        if (value >= 0) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','animateDuration'," + value + ");");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','animateDuration','slow');");
        }
        return this;
    }

    public ResizableBehavior setAnimateEasing(String value) {
        if (value == null) {
            this.options.remove((Object)"animateEasing");
        } else {
            this.options.put((Object)"animateEasing", (Object)value);
        }
        return this;
    }

    public ResizableBehavior setAnimateEasing(AjaxRequestTarget target, String value) {
        this.setAnimateEasing(value);
        if (value != null) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','animateEasing','" + value + "');");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','animateEasing','swing');");
        }
        return this;
    }

    public ResizableBehavior setAspectRatio(double value) {
        if (value <= 0.0) {
            this.options.remove((Object)"aspectRatio");
        } else {
            this.options.put((Object)"aspectRatio", (Object)value);
        }
        return this;
    }

    public ResizableBehavior setAspectRatio(boolean value) {
        if (value) {
            this.setAspectRatio(1.0);
        } else {
            this.setAspectRatio(0.0);
        }
        return this;
    }

    public ResizableBehavior setAspectRatio(AjaxRequestTarget target, double value) {
        this.setAspectRatio(value);
        if (value > 0.0) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','aspectRatio'," + value + ");");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','aspectRatio',false);");
        }
        return this;
    }

    public ResizableBehavior setAspectRatio(AjaxRequestTarget target, boolean value) {
        if (value) {
            this.setAspectRatio(target, 1.0);
        } else {
            this.setAspectRatio(target, 0.0);
        }
        return this;
    }

    public ResizableBehavior setAutoHide(boolean value) {
        if (!value) {
            this.options.remove((Object)"autoHide");
        } else {
            this.options.put((Object)"autoHide", (Object)value);
        }
        return this;
    }

    public ResizableBehavior setAutoHide(AjaxRequestTarget target, boolean value) {
        this.setAutoHide(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','autoHide'," + value + ");");
        return this;
    }

    public ResizableBehavior setDelay(int value) {
        if (value <= 0) {
            this.options.remove((Object)"delay");
        } else {
            this.options.put((Object)"delay", (Object)value);
        }
        return this;
    }

    public ResizableBehavior setDelay(AjaxRequestTarget target, int value) {
        this.setDelay(value);
        if (value >= 0) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','delay'," + value + ");");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','delay',0);");
        }
        return this;
    }

    public ResizableBehavior setDistance(int value) {
        if (value <= 0) {
            this.options.remove((Object)"distance");
        } else {
            this.options.put((Object)"distance", (Object)value);
        }
        return this;
    }

    public ResizableBehavior setDistance(AjaxRequestTarget target, int value) {
        this.setDistance(value);
        if (value >= 0) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','distance'," + value + ");");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','distance',1);");
        }
        return this;
    }

    public ResizableBehavior setGhost(boolean value) {
        if (!value) {
            this.options.remove((Object)"ghost");
        } else {
            this.options.put((Object)"ghost", (Object)value);
        }
        return this;
    }

    public ResizableBehavior setGhost(AjaxRequestTarget target, boolean value) {
        this.setGhost(value);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','ghost'," + value + ");");
        return this;
    }

    public ResizableBehavior setGrid(int x, int y) {
        if (x <= 1 && y <= 1) {
            this.options.remove((Object)"grid");
        } else {
            this.options.put("grid", new Object[]{x, y});
        }
        return this;
    }

    public ResizableBehavior setGrid(AjaxRequestTarget target, int x, int y) {
        this.setGrid(x, y);
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','grid',[" + x + "," + y + "]);");
        return this;
    }

    public ResizableBehavior setHandles(ResizableDirections ... directions) {
        String handles = "";
        if (directions == null || directions.length == 0) {
            this.options.remove((Object)"handles");
        } else {
            for (ResizableDirections direction : directions) {
                if (handles.length() > 0) {
                    handles = handles + ",";
                }
                handles = handles + direction.getDirection();
            }
            this.options.put((Object)"handles", (Object)handles);
        }
        return this;
    }

    public ResizableBehavior setHandles(AjaxRequestTarget target, ResizableDirections ... directions) {
        this.setHandles(directions);
        if (directions == null || directions.length == 0) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','handles','e, s, se');");
        } else {
            String handles = "";
            for (ResizableDirections direction : directions) {
                if (handles.length() > 0) {
                    handles = handles + ",";
                }
                handles = handles + direction.getDirection();
            }
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','handles','" + handles + "');");
        }
        return this;
    }

    public ResizableBehavior setHelper(String value) {
        if (value == null) {
            this.options.remove((Object)"helper");
        } else {
            this.options.put((Object)"helper", (Object)value);
        }
        return this;
    }

    public ResizableBehavior setHelper(AjaxRequestTarget target, String value) {
        this.setHelper(value);
        if (value != null) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','helper','" + value + "');");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','helper',false);");
        }
        return this;
    }

    public ResizableBehavior setMaxHeight(int value) {
        if (value <= 0) {
            this.options.remove((Object)"maxHeight");
        } else {
            this.options.put((Object)"maxHeight", (Object)value);
        }
        return this;
    }

    public ResizableBehavior setMaxHeight(AjaxRequestTarget target, int value) {
        this.setMaxHeight(value);
        if (value > 0) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','maxHeight'," + value + ");");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','maxHeight',null);");
        }
        return this;
    }

    public ResizableBehavior setMaxWidth(int value) {
        if (value <= 0) {
            this.options.remove((Object)"maxWidth");
        } else {
            this.options.put((Object)"maxWidth", (Object)value);
        }
        return this;
    }

    public ResizableBehavior setMaxWidth(AjaxRequestTarget target, int value) {
        this.setMaxWidth(value);
        if (value > 0) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','maxWidth'," + value + ");");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','maxWidth',null);");
        }
        return this;
    }

    public ResizableBehavior setminHeight(int value) {
        if (value <= 0) {
            this.options.remove((Object)"minHeight");
        } else {
            this.options.put((Object)"minHeight", (Object)value);
        }
        return this;
    }

    public ResizableBehavior setminHeight(AjaxRequestTarget target, int value) {
        this.setminHeight(value);
        if (value > 0) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','minHeight'," + value + ");");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','minHeight',10);");
        }
        return this;
    }

    public ResizableBehavior setminWidth(int value) {
        if (value <= 0) {
            this.options.remove((Object)"minWidth");
        } else {
            this.options.put((Object)"minWidth", (Object)value);
        }
        return this;
    }

    public ResizableBehavior setminWidth(AjaxRequestTarget target, int value) {
        this.setminWidth(value);
        if (value > 0) {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','minWidth'," + value + ");");
        } else {
            target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable('option','minWidth',10);");
        }
        return this;
    }

    public ResizableBehavior setWantOnresizeStartNotification(boolean value) {
        this.onResizeStartNotificationWanted = value;
        return this;
    }

    public ResizableBehavior setWantOnResizeNotification(boolean value) {
        this.onResizeNotificationWanted = value;
        return this;
    }

    protected JQueryAjaxBehavior.JsBuilder getJsBuilder() {
        if (this.onResizeStartNotificationWanted) {
            this.options.put((Object)EventType.RESIZE_START.eventName, (Object)new JQueryAjaxBehavior.JsFunction("function(ev,ui) { wicketAjaxGet('" + this.getCallbackUrl() + "&height='+jQuery(ui.size).attr('height')" + "+'&width='+jQuery(ui.size).attr('width')" + "+'&top='+jQuery(ui.position).attr('top')" + "+'&left='+jQuery(ui.position).attr('left')" + "+'&" + "wicketResizeEvent" + "=" + EventType.RESIZE_START + "&keys='+jQuery.jWicketSpecialKeysGetPressed()" + "); }"));
        } else {
            this.options.remove((Object)EventType.RESIZE_START.getEventName());
        }
        this.options.put((Object)EventType.RESIZE_END.eventName, (Object)new JQueryAjaxBehavior.JsFunction("function(ev,ui) { wicketAjaxGet('" + this.getCallbackUrl() + "&height='+jQuery(ui.size).attr('height')" + "+'&width='+jQuery(ui.size).attr('width')" + "+'&top='+jQuery(ui.position).attr('top')" + "+'&left='+jQuery(ui.position).attr('left')" + "+'&originalHeight='+jQuery(ui.originalSize).attr('height')" + "+'&originalWidth='+jQuery(ui.originalSize).attr('width')" + "+'&originalTop='+jQuery(ui.originalPosition).attr('top')" + "+'&originalLeft='+jQuery(ui.originalPosition).attr('left')" + "+'&" + "wicketResizeEvent" + "=" + EventType.RESIZE_END + "&keys='+jQuery.jWicketSpecialKeysGetPressed()" + "); }"));
        if (this.onResizeNotificationWanted) {
            this.options.put((Object)EventType.RESIZE.eventName, (Object)new JQueryAjaxBehavior.JsFunction("function(ev,ui) { wicketAjaxGet('" + this.getCallbackUrl() + "&height='+jQuery(ui.size).attr('height')" + "+'&width='+jQuery(ui.size).attr('width')" + "+'&top='+jQuery(ui.position).attr('top')" + "+'&left='+jQuery(ui.position).attr('left')" + "+'&" + "wicketResizeEvent" + "=" + EventType.RESIZE + "&keys='+jQuery.jWicketSpecialKeysGetPressed()" + "); }"));
        } else {
            this.options.remove((Object)EventType.RESIZE.getEventName());
        }
        JQueryAjaxBehavior.JsBuilder builder = new JQueryAjaxBehavior.JsBuilder();
        builder.append((Object)("jQuery('#" + this.getComponent().getMarkupId() + "').resizable("));
        builder.append((Object)"{");
        builder.append((Object)this.options.toString(this.rawOptions));
        builder.append((Object)"}");
        builder.append((Object)");");
        return builder;
    }

    protected void onResizeStart(AjaxRequestTarget target, int top, int left, int width, int height, SpecialKeys specialKeys) {
    }

    protected void onResize(AjaxRequestTarget target, int top, int left, int width, int height, SpecialKeys specialKeys) {
    }

    protected void onResized(AjaxRequestTarget target, int top, int left, int width, int height, int originalTop, int originalLeft, int originalWidth, int originalHeight, SpecialKeys specialKeys) {
    }

    public void disable(AjaxRequestTarget target) {
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable( 'disable' );");
        target.addComponent(this.getComponent());
    }

    public void enable(AjaxRequestTarget target) {
        target.appendJavascript("jQuery('#" + this.getComponent().getMarkupId() + "').resizable( 'enable' );");
        target.appendJavascript(this.getJsBuilder().toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EventType implements Serializable
    {
        UNKNOWN("*"),
        RESIZE_START("start"),
        RESIZE("resize"),
        RESIZE_END("stop");

        public static final String IDENTIFIER = "wicketResizeEvent";
        private final String eventName;

        private EventType(String eventName) {
            this.eventName = eventName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public static EventType stringToType(String s) {
            for (EventType t : EventType.values()) {
                if (!t.getEventName().equals(s)) continue;
                return t;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.eventName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResizableDirections {
        NORTH("n"),
        EAST("e"),
        SOUTH("s"),
        WEST("w"),
        NORTH_EAST("ne"),
        SOUTH_EAST("se"),
        SOUTH_WEST("sw"),
        NORTH_WEST("nw");

        private String direction;

        private ResizableDirections(String direction) {
            this.direction = direction;
        }

        public String getDirection() {
            return this.direction;
        }

        public String toString() {
            return this.getDirection();
        }
    }
}

