/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mbeanview;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.fixedfeedbackpanel.FixedFeedbackPanel;
import org.wicketstuff.mbeanview.DataUtil;
import org.wicketstuff.mbeanview.DataViewPanel;
import org.wicketstuff.mbeanview.MbeanServerLocator;

public class AttributeValuesPanel
extends Panel {
    private ModalWindow modalOutput;

    public AttributeValuesPanel(String id, final ObjectName objectName, MBeanAttributeInfo[] beanAttributeInfos, final MbeanServerLocator mbeanServerLocator) {
        super(id);
        Component[] componentArray = new Component[1];
        this.modalOutput = new ModalWindow("modalOutput");
        componentArray[0] = this.modalOutput;
        this.add(componentArray);
        this.modalOutput.setCookieName("modalOutput");
        Form form = new Form("form");
        this.add(new Component[]{form});
        form.add(new Component[]{new ListView("attributes", Arrays.asList(beanAttributeInfos)){

            protected void populateItem(ListItem item) {
                final MBeanAttributeInfo info = (MBeanAttributeInfo)item.getModelObject();
                item.add(new Component[]{new Label("name", info.getName())});
                try {
                    Object value = null;
                    if (info.isReadable()) {
                        try {
                            value = mbeanServerLocator.get().getAttribute(objectName, info.getName());
                        }
                        catch (RuntimeMBeanException e) {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            e.printStackTrace(pw);
                            item.error((Serializable)((Object)sw.toString()));
                        }
                    }
                    AjaxLink link = null;
                    Component[] componentArray = new Component[1];
                    link = new AjaxLink("value", (IModel)new Model((Serializable)value)){

                        public void onClick(AjaxRequestTarget target) {
                            AttributeValuesPanel.this.modalOutput.setContent((Component)new DataViewPanel(AttributeValuesPanel.this.modalOutput.getContentId(), this.getModelObject()));
                            AttributeValuesPanel.this.modalOutput.setTitle(info.getName());
                            AttributeValuesPanel.this.modalOutput.show(target);
                        }

                        public boolean isEnabled() {
                            return this.getModelObject() instanceof Collection || this.getModelObject() != null && this.getModelObject().getClass().isArray();
                        }

                        public boolean isVisible() {
                            return !info.isWritable();
                        }
                    };
                    componentArray[0] = link;
                    item.add(componentArray);
                    link.add(new Component[]{new Label("label", value == null ? null : value.toString())});
                    item.add(new Component[]{new TextField("editableValue", new AttributeModel(info, mbeanServerLocator, objectName)){

                        public boolean isVisible() {
                            return info.isWritable();
                        }
                    }});
                    item.add(new Component[]{new Button("submit", (IModel)new Model((Serializable)((Object)"Submit"))){

                        public boolean isVisible() {
                            return info.isWritable();
                        }
                    }});
                    item.add(new Component[]{new FixedFeedbackPanel("feedback", (Component)item)});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }});
    }

    public class AttributeModel
    implements IModel {
        private MBeanAttributeInfo attributeInfo;
        private MbeanServerLocator mbeanServerLocator;
        private ObjectName objectName;

        public AttributeModel(MBeanAttributeInfo attributeInfo, MbeanServerLocator mbeanServerLocator, ObjectName objectName) {
            this.attributeInfo = attributeInfo;
            this.mbeanServerLocator = mbeanServerLocator;
            this.objectName = objectName;
        }

        public Object getObject() {
            if (this.attributeInfo.isReadable()) {
                try {
                    return this.mbeanServerLocator.get().getAttribute(this.objectName, this.attributeInfo.getName());
                }
                catch (AttributeNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstanceNotFoundException e) {
                    e.printStackTrace();
                }
                catch (MBeanException e) {
                    e.printStackTrace();
                }
                catch (ReflectionException e) {
                    e.printStackTrace();
                }
                catch (RuntimeMBeanException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }

        public void setObject(Object object) {
            Attribute attribute = null;
            try {
                Object paramWithCorrectType = null;
                if (object != null) {
                    Class clazz = DataUtil.getClassFromInfo(this.attributeInfo);
                    paramWithCorrectType = DataUtil.tryParseToType(object, clazz);
                }
                attribute = new Attribute(this.attributeInfo.getName(), object == null ? null : paramWithCorrectType);
                this.mbeanServerLocator.get().setAttribute(this.objectName, attribute);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void detach() {
        }
    }
}

