/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mbeanview;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataUtil {
    public static Object tryParseToType(Object object, Class clazz) {
        try {
            return clazz.getConstructor(String.class).newInstance(object.toString());
        }
        catch (Exception e) {
            return object;
        }
    }

    public static Class getClassFromInfo(MBeanAttributeInfo attributeInfo) throws ClassNotFoundException {
        return DataUtil.getClassFromInfo(attributeInfo.getType());
    }

    public static Class getClassFromInfo(String jmxType) throws ClassNotFoundException {
        Class clazz = null;
        clazz = "boolean".equals(jmxType) ? Boolean.class : ("int".equals(jmxType) ? Integer.class : ("double".equals(jmxType) ? Double.class : ("long".equals(jmxType) ? Long.class : Class.forName(jmxType))));
        return clazz;
    }

    public static Object getCompatibleData(Object object, MBeanParameterInfo beanParameterInfo) throws ClassNotFoundException {
        return DataUtil.tryParseToType(object, DataUtil.getClassFromInfo(beanParameterInfo.getType()));
    }

    public static Set<Set<String>> parseToPropsSet(Set<ObjectName> domainNames) {
        HashSet<Set<String>> result = new HashSet<Set<String>>();
        for (ObjectName names : domainNames) {
            HashSet<String> propValue = new HashSet<String>();
            for (Map.Entry<String, String> entry : names.getKeyPropertyList().entrySet()) {
                propValue.add(entry.getKey() + "=" + entry.getValue());
            }
            result.add(propValue);
        }
        return result;
    }
}

