/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mbeanview;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.wicketstuff.mbeanview.ObjectViewPanel;

public class DataViewPanel
extends Panel {
    private static final String OUTPUT_ID = "output";

    public DataViewPanel(String id, Object param) {
        super(id);
        ArrayList<Object> contents = null;
        if (param != null) {
            if (param instanceof List) {
                contents = (ArrayList<Object>)param;
            } else if (param.getClass().isArray()) {
                int lenght = Array.getLength(param);
                if (lenght > 0) {
                    contents = new ArrayList();
                    for (int i = 0; i < lenght; ++i) {
                        contents.add(Array.get(param, i));
                    }
                }
            } else {
                contents = new ArrayList<Object>();
                contents.add(param);
            }
        }
        ListView contentsRepeater = new ListView("contents", contents){

            protected void populateItem(ListItem item) {
                Object value = item.getModelObject();
                if (value == null || value instanceof String || value.getClass().isPrimitive()) {
                    item.add(new Component[]{new Label(DataViewPanel.OUTPUT_ID, value == null ? null : value.toString())});
                } else {
                    item.add(new Component[]{new ObjectViewPanel(DataViewPanel.OUTPUT_ID, value)});
                }
            }
        };
        this.add(new Component[]{contentsRepeater});
    }
}

