/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mbeanview;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.markup.html.tree.Tree;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.wicketstuff.mbeanview.AttributeValuesPanel;
import org.wicketstuff.mbeanview.DataUtil;
import org.wicketstuff.mbeanview.MbeanServerLocator;
import org.wicketstuff.mbeanview.OperationsPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeansPanel
extends Panel
implements IHeaderContributor {
    public static final String VIEW_PANEL_ID = "view";
    private static final ResourceReference CSS = new ResourceReference(MBeansPanel.class, "css/MBeansPanel.css");

    public MBeansPanel(String id) {
        super(id);
        try {
            MbeanServerLocator reachMbeanServer = new MbeanServerLocator(){

                public MBeanServer get() {
                    return ManagementFactory.getPlatformMBeanServer();
                }
            };
            MBeanTree mBeansTree = new MBeanTree("mBeansTree", this.getTreeModel(reachMbeanServer));
            this.add(new Component[]{mBeansTree});
            this.add(new Component[]{new EmptyPanel(VIEW_PANEL_ID)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TreeModel getTreeModel(MbeanServerLocator reachMbeanServer) throws MalformedObjectNameException, NullPointerException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("root");
        DefaultTreeModel model = new DefaultTreeModel(rootNode);
        String[] domains = reachMbeanServer.get().getDomains();
        for (int i = 0; i < domains.length; ++i) {
            MbeanNode domainNode = new MbeanNode(domains[i]);
            rootNode.add(domainNode);
            Set<ObjectName> domainNames = reachMbeanServer.get().queryNames(null, new ObjectName(domains[i] + ":*"));
            this.addDomainsCildrens(domainNode, DataUtil.parseToPropsSet(domainNames));
            Enumeration<TreeNode> enumeration = domainNode.postorderEnumeration();
            HashSet<TreeNode> nodes = new HashSet<TreeNode>();
            while (enumeration.hasMoreElements()) {
                nodes.add(enumeration.nextElement());
            }
            for (DefaultMutableTreeNode defaultMutableTreeNode : nodes) {
                String query = domains[i] + ":";
                TreeNode[] path = defaultMutableTreeNode.getPath();
                if (path.length <= 2) continue;
                for (int j = 2; j < path.length; ++j) {
                    if (path[j] instanceof MbeanNode) {
                        query = query + ((MbeanNode)path[j]).getKeyValue();
                    }
                    if (j >= path.length - 1) continue;
                    query = query + ",";
                }
                Set<ObjectInstance> mBeans = reachMbeanServer.get().queryMBeans(null, new ObjectName(query));
                if (mBeans.size() <= 0) continue;
                for (ObjectInstance objectInstance : mBeans) {
                    ((MbeanNode)defaultMutableTreeNode).setObjectInstance(objectInstance, reachMbeanServer);
                }
            }
        }
        return model;
    }

    private void addDomainsCildrens(DefaultMutableTreeNode rootNode, Set<Set<String>> domainNames) {
        HashMap parentProps = new HashMap();
        for (Set<String> names : domainNames) {
            ArrayList<String> namesList = new ArrayList<String>(names);
            Collections.sort(namesList, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    String p1 = o1.split("=")[0];
                    String p2 = o2.split("=")[0];
                    if ("name".equals(p1)) {
                        return 1;
                    }
                    if ("name".equals(p2)) {
                        return -1;
                    }
                    if ("application".equals(p1) || "type".equals(p1)) {
                        return 1;
                    }
                    if ("application".equals(p2) || "type".equals(p2)) {
                        return -1;
                    }
                    return p1.compareTo(p2);
                }
            });
            if (namesList.size() <= 0) continue;
            if (parentProps.get(namesList.get(0)) == null) {
                parentProps.put(namesList.get(0), new HashSet());
            }
            names.remove(namesList.get(0));
            ((Set)parentProps.get(namesList.get(0))).add(names);
        }
        for (String parentProp : parentProps.keySet()) {
            MbeanNode newNode = new MbeanNode(null, parentProp);
            rootNode.add(newNode);
            this.addDomainsCildrens(newNode, (Set)parentProps.get(parentProp));
        }
    }

    public void renderHead(IHeaderResponse res) {
        res.renderCSSReference(CSS);
    }

    private class NotificationNode
    extends MbeanNode {
        private MBeanNotificationInfo beanNotificationInfo;

        public NotificationNode(MbeanNode parent, MBeanNotificationInfo mBeanNotificationInfo) {
            super(parent);
            this.beanNotificationInfo = mBeanNotificationInfo;
        }

        public String toString() {
            return this.beanNotificationInfo.getName();
        }
    }

    private class OperationNode
    extends MbeanNode {
        private MBeanOperationInfo beanOperationInfo;

        public OperationNode(OperationsNode parent, MBeanOperationInfo mBeanOperationInfo) {
            super(parent);
            this.beanOperationInfo = mBeanOperationInfo;
        }

        public Component getView(String wicketId) {
            return new OperationsPanel(wicketId, this.objectInstance.getObjectName(), new MBeanOperationInfo[]{this.beanOperationInfo}, this.mBeanServerLocator);
        }

        public String toString() {
            return this.beanOperationInfo.getName();
        }
    }

    private class OperationsNode
    extends MbeanNode {
        private MBeanOperationInfo[] beanOperationInfos;

        public OperationsNode(MbeanNode parent, MBeanOperationInfo[] beanOperationInfos) {
            super(parent);
            this.beanOperationInfos = beanOperationInfos;
            for (int i = 0; i < beanOperationInfos.length; ++i) {
                this.add(new OperationNode(this, beanOperationInfos[i]));
            }
        }

        public Component getView(String id) {
            return new OperationsPanel(id, this.objectInstance.getObjectName(), this.beanOperationInfos, this.mBeanServerLocator);
        }

        public String toString() {
            return "Operations";
        }
    }

    private class AttributeNode
    extends MbeanNode {
        private MBeanAttributeInfo attributeInfo;

        public AttributeNode(MbeanNode parent, MBeanAttributeInfo mBeanAttributeInfo) {
            super(parent);
            this.attributeInfo = mBeanAttributeInfo;
        }

        public Component getView(String wicketId) {
            return new AttributeValuesPanel(wicketId, this.objectInstance.getObjectName(), new MBeanAttributeInfo[]{this.attributeInfo}, this.mBeanServerLocator);
        }

        public String toString() {
            return this.attributeInfo.getName();
        }
    }

    private class AttributesNode
    extends MbeanNode {
        private MBeanAttributeInfo[] beanAttributeInfos;

        public AttributesNode(MbeanNode parent, MBeanAttributeInfo[] beanAttributeInfos) {
            super(parent);
            this.beanAttributeInfos = beanAttributeInfos;
            for (int i = 0; i < beanAttributeInfos.length; ++i) {
                this.add(new AttributeNode(this, beanAttributeInfos[i]));
            }
        }

        public Component getView(String id) {
            return new AttributeValuesPanel(id, this.objectInstance.getObjectName(), this.beanAttributeInfos, this.mBeanServerLocator);
        }

        public String toString() {
            return "Attributes";
        }
    }

    private class MbeanNode
    extends DefaultMutableTreeNode {
        protected ObjectInstance objectInstance;
        protected MbeanServerLocator mBeanServerLocator;
        protected String name;
        protected String keyValue;

        public MbeanNode(String domainName) {
            super(domainName);
        }

        public MbeanNode(ObjectInstance objectInstance, String keyValue) {
            this.objectInstance = objectInstance;
            this.keyValue = keyValue;
            this.name = keyValue.split("=")[1];
        }

        public MbeanNode(MbeanNode parent) {
            this.objectInstance = parent.objectInstance;
            this.mBeanServerLocator = parent.mBeanServerLocator;
            this.objectInstance = parent.objectInstance;
            this.keyValue = parent.keyValue;
        }

        public void setObjectInstance(ObjectInstance objectInstance, MbeanServerLocator reachMbeanServer) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
            this.objectInstance = objectInstance;
            this.mBeanServerLocator = reachMbeanServer;
            MBeanInfo info = reachMbeanServer.get().getMBeanInfo(objectInstance.getObjectName());
            MBeanAttributeInfo[] beanAttributeInfos = info.getAttributes();
            MBeanOperationInfo[] beanOperationInfos = info.getOperations();
            MBeanNotificationInfo[] beanNotificationInfos = info.getNotifications();
            if (beanAttributeInfos.length > 0) {
                this.add(new AttributesNode(this, beanAttributeInfos));
            }
            if (beanOperationInfos.length > 0) {
                this.add(new OperationsNode(this, beanOperationInfos));
            }
            if (beanNotificationInfos.length > 0) {
                DefaultMutableTreeNode notificationsNode = new DefaultMutableTreeNode("Notification");
                this.add(notificationsNode);
                for (int i = 0; i < beanNotificationInfos.length; ++i) {
                    notificationsNode.add(new NotificationNode(this, beanNotificationInfos[i]));
                }
            }
        }

        public String toString() {
            return this.name != null && !"".equals(this.name.trim()) ? this.name : super.toString();
        }

        public String getKeyValue() {
            return this.keyValue;
        }

        public Component getView(String wicketId) {
            return new MBeanTree(wicketId, new DefaultTreeModel(this));
        }
    }

    private class MBeanTree
    extends Tree {
        public MBeanTree(String id, TreeModel model) {
            super(id, model);
            this.getTreeState().expandNode(this.getModelObject().getRoot());
        }

        protected ResourceReference getCSS() {
            return CSS;
        }

        protected void onNodeLinkClicked(AjaxRequestTarget target, TreeNode node) {
            if (node instanceof MbeanNode) {
                MBeansPanel.this.replace(((MbeanNode)node).getView(MBeansPanel.VIEW_PANEL_ID));
                this.setResponsePage(MBeansPanel.this.getPage());
            }
        }

        protected Component newNodeIcon(MarkupContainer parent, String id, TreeNode node) {
            DefaultMutableTreeNode mutableNode;
            if (node instanceof DefaultMutableTreeNode && (mutableNode = (DefaultMutableTreeNode)node).getChildCount() > 0 && (mutableNode.getChildAt(0) instanceof AttributeNode || mutableNode.getChildAt(0) instanceof OperationNode || mutableNode.getChildAt(0) instanceof NotificationNode)) {
                return new EmptyPanel(id).add(new IBehavior[]{new SimpleAttributeModifier("style", (CharSequence)"width:0;")});
            }
            return super.newNodeIcon(parent, id, node);
        }
    }
}

