/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mbeanview;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;

public class ObjectViewPanel
extends Panel {
    public ObjectViewPanel(String id, Object object) {
        super(id);
        this.add(new Component[]{new Label("className", object.getClass().getName())});
        this.add(new Component[]{new Label("toString", object.toString())});
        ArrayList<PropValue> properties = new ArrayList<PropValue>();
        Method[] methods = object.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().startsWith("get") || methods[i].getParameterTypes().length != 0) continue;
            PropValue prop = new PropValue();
            try {
                prop.property = methods[i].getName();
                prop.value = methods[i].invoke(object, (Object[])null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            properties.add(prop);
        }
        this.add(new Component[]{new ListView<PropValue>("properties", properties){

            protected void populateItem(ListItem<PropValue> item) {
                item.add(new Component[]{new Label("property", ((PropValue)item.getModelObject()).property)});
                item.add(new Component[]{new Label("value", ((PropValue)item.getModelObject()).value == null ? null : ((PropValue)item.getModelObject()).value.toString())});
            }
        }});
    }

    public static class PropValue
    implements Serializable {
        String property;
        Object value;
    }
}

