/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.mbeanview;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.ComponentFeedbackPanel;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.mbeanview.DataUtil;
import org.wicketstuff.mbeanview.DataViewPanel;
import org.wicketstuff.mbeanview.MbeanServerLocator;

public class OperationsPanel
extends Panel {
    private MbeanServerLocator beanServerLocator;
    private ObjectName objectName;
    private ModalWindow modalOutput;

    public OperationsPanel(String id, ObjectName objectName, MBeanOperationInfo[] beanOperationInfos, MbeanServerLocator beanServerLocator) {
        super(id);
        this.beanServerLocator = beanServerLocator;
        this.objectName = objectName;
        Component[] componentArray = new Component[1];
        this.modalOutput = new ModalWindow("modalOutput");
        componentArray[0] = this.modalOutput;
        this.add(componentArray);
        this.modalOutput.setTitle("Operation result view.");
        this.modalOutput.setCookieName("modalOutput");
        Form form = new Form("form");
        this.add(new Component[]{form});
        ListView operations = new ListView("operations", Arrays.asList(beanOperationInfos)){

            protected void populateItem(final ListItem item) {
                MBeanOperationInfo info = (MBeanOperationInfo)item.getModelObject();
                String returnLbl = info.getReturnType();
                try {
                    Class<?> c = Class.forName(info.getReturnType());
                    returnLbl = c.isArray() ? c.getComponentType().getSimpleName() + "[]" : c.getSimpleName();
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                item.add(new Component[]{new Label("return", returnLbl)});
                ParameterRepeater parameterRepeater = new ParameterRepeater("parameters", info.getSignature());
                item.add(new Component[]{parameterRepeater});
                ComponentFeedbackPanel feedback = new ComponentFeedbackPanel("feedback", (Component)item);
                feedback.setOutputMarkupId(true);
                item.add(new Component[]{feedback});
                item.add(new Component[]{new OperationButton("method", parameterRepeater, info, (FeedbackPanel)feedback){
                    final /* synthetic */ FeedbackPanel val$feedback;
                    {
                        this.val$feedback = feedbackPanel;
                        super(x0, x1, x2);
                    }

                    protected void onSuccessful(Object returnObj, AjaxRequestTarget target) {
                        if (returnObj == null) {
                            item.info("Successful call");
                            target.addComponent((Component)this.val$feedback);
                        }
                    }
                }});
            }
        };
        form.add(new Component[]{operations});
    }

    private class ParameterRepeater
    extends ListView {
        private Map<MBeanParameterInfo, IModel> parametersValues;
        private MBeanParameterInfo[] beanParameterInfos;

        public ParameterRepeater(String id, MBeanParameterInfo[] beanParameterInfos) {
            super(id, Arrays.asList(beanParameterInfos));
            this.parametersValues = new HashMap<MBeanParameterInfo, IModel>();
            this.beanParameterInfos = beanParameterInfos;
        }

        protected void populateItem(ListItem item) {
            MBeanParameterInfo param = (MBeanParameterInfo)item.getModelObject();
            item.add(new Component[]{new Label("parameterName", param.getName())});
            this.parametersValues.put(param, (IModel)new Model());
            item.add(new Component[]{new TextField("parameterValue", this.parametersValues.get(param))});
        }

        public Object[] getParams() {
            Object[] params = new Object[this.beanParameterInfos.length];
            for (int i = 0; i < params.length; ++i) {
                try {
                    params[i] = DataUtil.getCompatibleData(this.parametersValues.get(this.beanParameterInfos[i]).getObject(), this.beanParameterInfos[i]);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
            }
            return params;
        }

        public String[] getSignatures() {
            String[] params = new String[this.beanParameterInfos.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = this.beanParameterInfos[i].getType();
            }
            return params;
        }
    }

    private class OperationButton
    extends AjaxButton {
        private ParameterRepeater parameterRepeater;
        private MBeanFeatureInfo info;

        public OperationButton(String id, ParameterRepeater parameterRepeater, MBeanFeatureInfo info) {
            super(id);
            this.setModel((IModel)new Model((Serializable)((Object)info.getName())));
            this.parameterRepeater = parameterRepeater;
            this.info = info;
        }

        protected void onSubmit(AjaxRequestTarget target, Form form) {
            Object returnObj = null;
            try {
                returnObj = OperationsPanel.this.beanServerLocator.get().invoke(OperationsPanel.this.objectName, this.info.getName(), this.parameterRepeater.getParams(), this.parameterRepeater.getSignatures());
                this.onSuccessful(returnObj, target);
            }
            catch (Exception e) {
                returnObj = new ArrayList<String>();
                ((ArrayList)returnObj).add(e.getMessage());
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                ((ArrayList)returnObj).add(sw.toString());
            }
            if (returnObj != null) {
                OperationsPanel.this.modalOutput.setContent((Component)new DataViewPanel(OperationsPanel.this.modalOutput.getContentId(), returnObj));
                OperationsPanel.this.modalOutput.show(target);
            }
        }

        protected void onSuccessful(Object returnObj, AjaxRequestTarget target) {
        }
    }
}

