/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.proxy;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.servlet.AbortWithHttpStatusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WFSProxyBehavior
extends AbstractAjaxBehavior {
    private static final long serialVersionUID = -4710843334047637872L;
    private static final Logger log = LoggerFactory.getLogger(WFSProxyBehavior.class);
    private String wmsURL;

    public void onRequest() {
        WebRequestCycle wrc = (WebRequestCycle)RequestCycle.get();
        wrc.setRequestTarget((IRequestTarget)new ProxyResponseTarget());
        wrc.setRedirect(false);
    }

    public String getProxyUrl(boolean onlyTargetActivePage) {
        return this.getCallbackUrl(true) + "&url=";
    }

    class ProxyResponseTarget
    implements IRequestTarget {
        ProxyResponseTarget() {
        }

        public void detach(RequestCycle requestCycle) {
        }

        public void respond(RequestCycle requestCycle) {
            block13: {
                WebRequest wr = (WebRequest)requestCycle.getRequest();
                WebResponse response = (WebResponse)requestCycle.getResponse();
                HttpServletRequest request = wr.getHttpServletRequest();
                String requestURL = request.getParameter("url");
                if (requestURL == null) {
                    log.warn("requestURL could not be resolved.");
                    throw new AbortWithHttpStatusException(412, false);
                }
                try {
                    HttpClient client = new HttpClient();
                    if (request.getMethod().toLowerCase().equals("get")) {
                        Header[] headerArrayResponse;
                        String decodedURL = URLDecoder.decode(requestURL, "UTF-8");
                        StringBuffer getUrl = new StringBuffer(decodedURL);
                        Set parameters = request.getParameterMap().keySet();
                        boolean first = true;
                        for (String p : parameters) {
                            if (p.equals("url") || p.startsWith("wicket:")) continue;
                            String value = request.getParameter(p);
                            if (first) {
                                getUrl.append("?");
                                first = false;
                            } else {
                                getUrl.append("&");
                            }
                            getUrl.append(p);
                            getUrl.append("=");
                            getUrl.append(URLEncoder.encode(value, "UTF-8"));
                        }
                        log.debug("Get = " + getUrl.toString());
                        GetMethod getMethod = new GetMethod(getUrl.toString());
                        int proxyResponseCode = client.executeMethod((HttpMethod)getMethod);
                        log.debug("redirected get, code = " + proxyResponseCode);
                        if (proxyResponseCode != 200) {
                            throw new AbortWithHttpStatusException(proxyResponseCode, false);
                        }
                        for (Header header : headerArrayResponse = getMethod.getResponseHeaders()) {
                            response.setHeader(header.getName(), header.getValue());
                        }
                        InputStream inputStreamProxyResponse = getMethod.getResponseBodyAsStream();
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStreamProxyResponse);
                        response.write((InputStream)bufferedInputStream);
                        break block13;
                    }
                    if (request.getMethod().toLowerCase().equals("post")) {
                        Header[] headerArrayResponse;
                        String decodedURL = URLDecoder.decode(requestURL, "UTF-8");
                        PostMethod pm = new PostMethod(decodedURL);
                        Set parameters = request.getParameterMap().keySet();
                        for (String p : parameters) {
                            String value = request.getParameter(p);
                            pm.setParameter(p, value);
                        }
                        pm.setContentChunked(true);
                        pm.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)request.getInputStream()));
                        int proxyResponseCode = client.executeMethod((HttpMethod)pm);
                        log.debug("redirected post, code = " + proxyResponseCode);
                        if (proxyResponseCode != 200) {
                            throw new AbortWithHttpStatusException(proxyResponseCode, false);
                        }
                        for (Header header : headerArrayResponse = pm.getResponseHeaders()) {
                            response.setHeader(header.getName(), header.getValue());
                        }
                        InputStream inputStreamProxyResponse = pm.getResponseBodyAsStream();
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStreamProxyResponse);
                        response.write((InputStream)bufferedInputStream);
                        break block13;
                    }
                    throw new AbortWithHttpStatusException(404, false);
                }
                catch (Exception e) {
                    log.error("getInputStream() failed", (Throwable)e);
                    throw new AbortWithHttpStatusException(404, false);
                }
            }
        }
    }
}

