/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.phonebook;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import wicket.contrib.phonebook.Contact;
import wicket.contrib.phonebook.ContactDao;
import wicket.contrib.phonebook.QueryParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IbatisContactDao
extends SqlMapClientDaoSupport
implements ContactDao {
    public Contact load(long id) throws DataAccessException {
        return (Contact)this.getSqlMapClientTemplate().queryForObject("getContact", (Object)new Long(id));
    }

    public Contact save(Contact contact) {
        if (contact.getId() == 0L) {
            this.getSqlMapClientTemplate().insert("insertContact", (Object)contact);
        } else {
            this.getSqlMapClientTemplate().update("updateContact", (Object)contact);
        }
        return contact;
    }

    public void delete(long id) {
        this.getSqlMapClientTemplate().delete("deleteContact", (Object)new Long(id));
    }

    public Iterator<Contact> find(QueryParam qp, Contact filter) {
        Map map = this.createMap(filter);
        map.put("sort", qp.getSort());
        map.put("sortasc", qp.isSortAsc() ? " asc" : " desc");
        List list = this.getSqlMapClientTemplate().queryForList("getContactList", (Object)map, qp.getFirst(), qp.getCount());
        return list.listIterator();
    }

    public int count(Contact filter) {
        Map map = this.createMap(filter);
        Integer count = (Integer)this.getSqlMapClientTemplate().queryForObject("getContactCount", (Object)map);
        return count;
    }

    public List<String> getUniqueLastNames() {
        return this.getSqlMapClientTemplate().queryForList("getUniqueLastNames", null);
    }

    private Map<String, String> createMap(Contact filter) {
        String firstname = filter.getFirstname();
        String lastname = filter.getLastname();
        String email = filter.getEmail();
        String phone = filter.getPhone();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("firstname", firstname == null ? null : "%" + firstname.toUpperCase() + "%");
        map.put("lastname", lastname);
        map.put("email", email == null ? null : "%" + email.toUpperCase() + "%");
        map.put("phone", phone == null ? null : "%" + phone.toUpperCase() + "%");
        return map;
    }
}

