/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.examples;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.wicket.Application;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.ws.api.message.ConnectedMessage;
import org.wicketstuff.examples.HomePage;
import org.wicketstuff.examples.WicketApplication;

public class WicketApplication
extends WebApplication {
    private Set<ConnectedMessage> incrementConnected = new HashSet();
    private volatile int incrementCounter = 0;
    private Set<ConnectedMessage> decrementConnected = new HashSet();
    private volatile int decrementCounter = 30;
    private Set<ConnectedMessage> incrementGridRowConnected = new HashSet();
    private volatile int incrementRowCounter = -1;

    public Class<HomePage> getHomePage() {
        return HomePage.class;
    }

    public RuntimeConfigurationType getConfigurationType() {
        return RuntimeConfigurationType.DEVELOPMENT;
    }

    public void init() {
        this.getCspSettings().blocking().disabled();
        super.init();
        IncrementCounterTask incrementTask = new IncrementCounterTask(this);
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate((Runnable)incrementTask, 2L, 2L, TimeUnit.SECONDS);
        DecrementCounterTask decrementTask = new DecrementCounterTask(this);
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate((Runnable)decrementTask, 2L, 2L, TimeUnit.SECONDS);
        IncrementRowCounterTask rowIncrementTask = new IncrementRowCounterTask(this);
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate((Runnable)rowIncrementTask, 2L, 2L, TimeUnit.SECONDS);
    }

    public static WicketApplication get() {
        return (WicketApplication)Application.get();
    }

    public void addIncrementConnectMessage(ConnectedMessage connectedMessage) {
        this.incrementConnected.add(connectedMessage);
    }

    public void addDecrementConnectMessage(ConnectedMessage connectedMessage) {
        this.decrementConnected.add(connectedMessage);
    }

    public void addGridRowIncrementConnect(ConnectedMessage connectedMessage) {
        this.incrementGridRowConnected.add(connectedMessage);
    }
}

