/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.webflow;

import java.lang.reflect.Constructor;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.engine.RequestControlContext;
import org.wicketstuff.webflow.IFlowContainerPanel;
import org.wicketstuff.webflow.IPageFlowContainer;
import org.wicketstuff.webflow.controller.PageFlowController;
import org.wicketstuff.webflow.session.FlowState;
import org.wicketstuff.webflow.session.PageFlowSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FlowUtils.class);

    public static Class<? extends WebPage> getNextPage(String eventId) {
        String currentViewState = PageFlowSession.get().getFlowState().getCurrentViewState();
        Class<? extends Component> transitionedViewStateClass = PageFlowController.resumeApplicationFlow(currentViewState, eventId);
        if (transitionedViewStateClass != null) {
            return transitionedViewStateClass;
        }
        return transitionedViewStateClass;
    }

    public static void setResponsePageForEventId(String eventId) {
        String currentViewState = PageFlowSession.get().getFlowState().getCurrentViewState();
        Class<? extends Component> transitionedViewStateClassName = PageFlowController.resumeApplicationFlow(currentViewState, eventId);
        if (transitionedViewStateClassName != null) {
            PageParameters transitionViewStateParameters = new PageParameters();
            RequestCycle.get().setResponsePage(transitionedViewStateClassName, transitionViewStateParameters);
        }
    }

    public static void doEnterHelper(RequestControlContext context, int stepNumber) {
        String stateId = context.getCurrentState().getId();
        PageFlowSession.get().getFlowState().setCurrentViewStateId(stateId);
        PageFlowSession.get().getFlowState().setCurrentViewStepNumber(stepNumber, stateId);
    }

    public static void addFeedbackErrorBadUrl(String caller) {
    }

    public static void addFeedbackErrorBackDisallowed(String caller) {
    }

    public static void pageFlowTransition(Component triggeringComponent, AjaxRequestTarget target, String eventId) {
        PageFlowSession<?> pageFlowSession = PageFlowSession.get();
        Class<? extends Component> transitionedViewStateClass = PageFlowController.resumeApplicationFlow(pageFlowSession.getFlowState().getCurrentViewState(), eventId);
        if (transitionedViewStateClass != null) {
            Panel nextPanel = FlowUtils.getPageFlowContentPanel(transitionedViewStateClass);
            IFlowContainerPanel containerPanel = (IFlowContainerPanel)triggeringComponent.findParent(IFlowContainerPanel.class);
            Panel component = containerPanel.getContentPanel();
            if (component instanceof Panel) {
                containerPanel.setContentPanel(nextPanel);
                containerPanel.onPanelFlowChange(target);
            }
            target.addComponent((Component)nextPanel);
            StringBuffer yuiRegisterJS = new StringBuffer().append("YUI({filter: 'raw'}).use('history', function(Y) {\n").append(" var history = new Y.HistoryHash();").append(" history.addValue('flowExecutionKey', '").append(pageFlowSession.getFlowState().getCurrentViewState()).append("');\n").append("});\n");
            target.appendJavascript(yuiRegisterJS.toString());
        }
    }

    public static Panel getPageFlowContentPanel(Class<? extends Component> containerPanelClass) {
        Panel flowPanel = null;
        if (containerPanelClass != null) {
            try {
                Constructor<? extends Component> constructor = containerPanelClass.getConstructor(String.class);
                Component object = constructor.newInstance("panelFlowContent");
                if (object instanceof Panel) {
                    flowPanel = (Panel)object;
                }
            }
            catch (Exception exception) {
                LOG.error("An exception occurred while trying to find panel class name retrieved from Spring Web Flow " + containerPanelClass.getName(), (Throwable)exception);
            }
        }
        return flowPanel;
    }

    public static Class<? extends Component> getFlowStartStateClass() {
        FlowState<?> flowState = PageFlowSession.get().getFlowState();
        String startViewState = flowState.getStartViewState();
        Class<Component> homePanelClass = null;
        if (!Strings.isEmpty((CharSequence)startViewState)) {
            homePanelClass = flowState.getStartViewClass();
        } else {
            String flowId = ((IPageFlowContainer)Application.get()).getFlowId();
            homePanelClass = PageFlowController.startApplicationFlow(flowId);
        }
        if (homePanelClass == null) {
            LOG.error("An exception occurred while trying to retrieve the home page class for the application");
        }
        return homePanelClass;
    }
}

