/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.webflow.app;

import javax.servlet.ServletContext;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.Request;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.webflow.engine.builder.FlowArtifactFactory;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.executor.FlowExecutor;
import org.wicketstuff.webflow.FlowUtils;
import org.wicketstuff.webflow.IPageFlowContainer;
import org.wicketstuff.webflow.controller.PageFlowRequestCycleProcessor;
import org.wicketstuff.webflow.session.PageFlowSession;
import org.wicketstuff.webflow.view.WicketFlowArtifactFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PageFlowWebApplication
extends WebApplication
implements IPageFlowContainer {
    private ApplicationContext applicationContext;

    public PageFlowWebApplication() {
        this(null);
    }

    public PageFlowWebApplication(ApplicationContext applicationContext2) {
        this.applicationContext = applicationContext2;
    }

    public Class<? extends Page> getHomePage() {
        return FlowUtils.getFlowStartStateClass();
    }

    public Session newSession(Request request, Response response) {
        return new PageFlowSession(request);
    }

    protected void init() {
        super.init();
        if (this.applicationContext == null) {
            ServletContext sc = this.getServletContext();
            this.applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
        }
        WicketFlowArtifactFactory factory = new WicketFlowArtifactFactory();
        FlowBuilderServices flowBuilderServices = (FlowBuilderServices)this.applicationContext.getBean("flowBuilderServices");
        flowBuilderServices.setFlowArtifactFactory((FlowArtifactFactory)factory);
    }

    protected final IRequestCycleProcessor newRequestCycleProcessor() {
        return new PageFlowRequestCycleProcessor();
    }

    public final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public FlowExecutor getFlowExecutor() {
        return (FlowExecutor)this.applicationContext.getBean("flowExecutor");
    }

    public static PageFlowWebApplication get() {
        Application application = Application.get();
        if (!(application instanceof PageFlowWebApplication)) {
            throw new WicketRuntimeException("The application attached to the current thread is not a " + PageFlowWebApplication.class.getSimpleName());
        }
        return (PageFlowWebApplication)application;
    }

    public boolean isProgressBarToBeDisplayed() {
        return false;
    }
}

