/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.webflow.components;

import org.apache.wicket.Component;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.webflow.FlowUtils;
import org.wicketstuff.webflow.IFlowContainerPanel;
import org.wicketstuff.webflow.components.WebFlowPanel;
import org.wicketstuff.webflow.controller.SpringWebFlowFacade;
import org.wicketstuff.webflow.session.FlowState;
import org.wicketstuff.webflow.session.PageFlowSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebFlowContainerPanel
extends Panel
implements IHeaderContributor,
IFlowContainerPanel {
    private static final Logger LOG = LoggerFactory.getLogger(WebFlowContainerPanel.class);
    private static final long serialVersionUID = 1L;
    private Panel contentPanel;

    public WebFlowContainerPanel(String id) {
        super(id);
        this.setContentPanel(new WebFlowPanel("panelFlowContent"));
        this.add(new IBehavior[]{new CallBackBehavior()});
    }

    @Override
    public Panel getContentPanel() {
        return this.contentPanel;
    }

    @Override
    public void setContentPanel(Panel newContentPanel) {
        this.addOrReplace(new Component[]{newContentPanel});
        this.contentPanel = newContentPanel;
    }

    public void renderHead(IHeaderResponse response) {
        response.renderCSSReference(new ResourceReference(WebFlowContainerPanel.class, "WebFlowContainerPanel.css"));
        response.renderJavascriptReference(new ResourceReference(WebFlowContainerPanel.class, "WebFlowContainerPanel.js"));
        if (response instanceof WebResponse) {
            ((WebResponse)response).setHeader("Pragma", "no-cache");
            ((WebResponse)response).setHeader("Cache-Control", "no-cache, max-age=0, must-revalidate, no-store");
        }
    }

    @Override
    public void onPanelFlowChange(AjaxRequestTarget target) {
    }

    private Class<? extends Component> getContentPanelClass() {
        Class<? extends Component> contentPanelClass = null;
        String flowExecutionKey = RequestCycle.get().getRequest().getParameter("flowExecutionKey");
        FlowState<?> flowState = PageFlowSession.get().getFlowState();
        String currentViewState = flowState.getCurrentViewState();
        if (Strings.isEmpty((CharSequence)flowExecutionKey)) {
            contentPanelClass = this.getPanelClassNoKey(flowState, currentViewState);
        } else if ("DONE".equals(flowExecutionKey)) {
            contentPanelClass = this.getPanelClassDoneKey(flowState, currentViewState);
        } else if ("initialState".equals(flowExecutionKey)) {
            flowState.setStartViewState(null);
            contentPanelClass = FlowUtils.getFlowStartStateClass();
        } else {
            contentPanelClass = this.getPanelClassOtherKey(flowState, currentViewState, flowExecutionKey);
        }
        return contentPanelClass;
    }

    private Class<? extends Component> getPanelClassOtherKey(FlowState<?> flowState, String currentViewState, String flowExecutionKey) {
        Class<? extends Component> contentPanelClass;
        if (Strings.isEmpty((CharSequence)currentViewState)) {
            flowState.setStartViewState(null);
            contentPanelClass = FlowUtils.getFlowStartStateClass();
        } else if (new SpringWebFlowFacade().isFlowExecutionKeyValid(flowExecutionKey)) {
            if (currentViewState.equals(flowExecutionKey)) {
                contentPanelClass = new SpringWebFlowFacade().getViewStateClass(flowExecutionKey);
                flowState.setLastRenderedViewClass(contentPanelClass);
            } else {
                flowState.setCurrentViewState(flowExecutionKey);
                Class<? extends Component> viewStateClass = new SpringWebFlowFacade().getViewStateClass(flowExecutionKey);
                if (viewStateClass != null) {
                    contentPanelClass = viewStateClass;
                    flowState.setLastRenderedViewClass(contentPanelClass);
                } else {
                    FlowUtils.addFeedbackErrorBadUrl("FLOW_CONTAINER_3");
                    contentPanelClass = flowState.getLastRenderedViewClass();
                }
            }
        } else if (currentViewState.equals("DONE")) {
            FlowUtils.addFeedbackErrorBackDisallowed("FLOW_CONTAINER_1");
            contentPanelClass = flowState.getLastRenderedViewClass();
        } else {
            FlowUtils.addFeedbackErrorBadUrl("FLOW_CONTAINER_2");
            contentPanelClass = flowState.getLastRenderedViewClass();
        }
        return contentPanelClass;
    }

    private Class<? extends Component> getPanelClassDoneKey(FlowState<?> flowState, String currentViewState) {
        Class<? extends Component> contentPanelClass;
        if (Strings.isEmpty((CharSequence)currentViewState)) {
            flowState.setStartViewState(null);
            contentPanelClass = FlowUtils.getFlowStartStateClass();
        } else if (currentViewState.equals("DONE")) {
            flowState.setLastRenderedViewClass(flowState.getFinalViewClass());
            contentPanelClass = flowState.getFinalViewClass();
        } else {
            FlowUtils.addFeedbackErrorBackDisallowed("FLOW_CONTAINER_4");
            flowState.setHasPageFlowErrorMessages(true);
            contentPanelClass = flowState.getLastRenderedViewClass();
        }
        return contentPanelClass;
    }

    private Class<? extends Component> getPanelClassNoKey(FlowState<?> flowState, String currentViewState) {
        Class<? extends Component> contentPanelClass;
        if (Strings.isEmpty((CharSequence)currentViewState)) {
            contentPanelClass = FlowUtils.getFlowStartStateClass();
        } else if (currentViewState.equals("DONE")) {
            flowState.setStartViewState(null);
            contentPanelClass = FlowUtils.getFlowStartStateClass();
        } else {
            contentPanelClass = flowState.getLastRenderedViewClass();
        }
        return contentPanelClass;
    }

    private class CallBackBehavior
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        private CallBackBehavior() {
        }

        public void renderHead(IHeaderResponse response) {
            super.renderHead(response);
            String callbackUrl = ((Object)this.getCallbackUrl()).toString();
            if (callbackUrl.indexOf("flowExecutionKey=") != -1) {
                callbackUrl = callbackUrl.substring(0, callbackUrl.indexOf("&flowExecutionKey="));
            }
            StringBuffer sb = new StringBuffer().append("function goBackTo(flowExecutionKey) { \n").append("  wicketAjaxGet('").append(callbackUrl).append("&flowExecutionKey=' + flowExecutionKey);\n").append("}\n");
            response.renderJavascript((CharSequence)sb.toString(), "BackButtonJS");
        }

        protected void respond(AjaxRequestTarget target) {
            Panel flowPanel = null;
            Class contentPanelClass = WebFlowContainerPanel.this.getContentPanelClass();
            if (contentPanelClass != null) {
                flowPanel = FlowUtils.getPageFlowContentPanel(contentPanelClass);
                if (flowPanel != null) {
                    flowPanel.setOutputMarkupId(true);
                    WebFlowContainerPanel.this.contentPanel.replaceWith((Component)flowPanel);
                    WebFlowContainerPanel.this.contentPanel = flowPanel;
                }
            } else {
                LOG.error("Flow panel class name cannot be determined for the back button request from the client");
            }
            if (flowPanel != null) {
                target.addComponent((Component)flowPanel);
            }
            WebFlowContainerPanel.this.onPanelFlowChange(target);
        }
    }
}

