/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.webflow.controller;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.wicket.Component;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.State;
import org.wicketstuff.webflow.context.PageFlowSharedContext;
import org.wicketstuff.webflow.context.PageFlowSharedContextHolder;
import org.wicketstuff.webflow.controller.SpringWebFlowFacade;
import org.wicketstuff.webflow.session.PageFlowSession;
import org.wicketstuff.webflow.session.ProgressLink;
import org.wicketstuff.webflow.state.IProgressBarState;
import org.wicketstuff.webflow.state.WicketEndState;
import org.wicketstuff.webflow.state.WicketViewState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFlowController {
    private static final Logger LOG = LoggerFactory.getLogger(PageFlowController.class);

    public static Class<? extends Component> startApplicationFlow(String flowId) {
        Class<? extends Component> launchedViewStateClass = null;
        if (!Strings.isEmpty((CharSequence)flowId)) {
            PageFlowSharedContextHolder.initializeSharedContext();
            SpringWebFlowFacade webFlowFacade = new SpringWebFlowFacade();
            String launchViewState = webFlowFacade.launchWebFlowExecution(flowId);
            PageFlowSharedContext sharedContext = PageFlowSharedContextHolder.getSharedContext();
            launchedViewStateClass = sharedContext.getRenderedViewStateClass();
            PageFlowSharedContextHolder.clearSharedContext();
            PageFlowSession<?> pageFlowAppSession = PageFlowSession.get();
            pageFlowAppSession.getFlowState().setCurrentViewState(launchViewState);
            pageFlowAppSession.getFlowState().setStartViewState(launchViewState);
            pageFlowAppSession.getFlowState().setStartViewClass(launchedViewStateClass);
            pageFlowAppSession.getFlowState().setLastRenderedViewClass(launchedViewStateClass);
        }
        return launchedViewStateClass;
    }

    public static Class<? extends Component> resumeApplicationFlow(String inputViewState, String eventId) {
        Class<? extends Component> transitionedViewStateClass = null;
        if (!Strings.isEmpty((CharSequence)inputViewState) && !Strings.isEmpty((CharSequence)eventId)) {
            PageFlowSharedContextHolder.initializeSharedContext();
            PageFlowSharedContextHolder.getSharedContext().setEventId(eventId);
            SpringWebFlowFacade webFlowFacade = new SpringWebFlowFacade();
            String transitionedViewState = webFlowFacade.resumeWebFlowExecution(inputViewState);
            PageFlowSharedContext sharedContext = PageFlowSharedContextHolder.getSharedContext();
            transitionedViewStateClass = sharedContext.getRenderedViewStateClass();
            PageFlowSharedContextHolder.clearSharedContext();
            PageFlowSession<?> pageFlowAppSession = PageFlowSession.get();
            pageFlowAppSession.getFlowState().setCurrentViewState(transitionedViewState);
            pageFlowAppSession.getFlowState().setLastRenderedViewClass(transitionedViewStateClass);
            if ("DONE".equals(transitionedViewState)) {
                pageFlowAppSession.getFlowState().setFinalViewClass(transitionedViewStateClass);
            }
        }
        return transitionedViewStateClass;
    }

    public static List<ProgressLink> populateProgressBarStates() {
        String viewStateString = PageFlowSession.get().getFlowState().getStartViewState();
        Flow flow = new SpringWebFlowFacade().getFlow(viewStateString);
        Map<Integer, State> progressBarStateMap = PageFlowController.collectProgressStates(flow);
        Iterator<Integer> iterator = progressBarStateMap.keySet().iterator();
        ArrayList<ProgressLink> progressLinks = new ArrayList<ProgressLink>();
        int stepCounter = 0;
        while (iterator.hasNext()) {
            Integer stepNumber = iterator.next();
            State progressBarState = progressBarStateMap.get(stepNumber);
            if (!(progressBarState instanceof IProgressBarState)) continue;
            IProgressBarState viewState = (IProgressBarState)progressBarState;
            String progressBarText = viewState.getProgressBarText();
            if (!Strings.isEmpty((CharSequence)viewState.getProgressBarText()) && !viewState.getProgressBarText().equals(progressBarText)) {
                ++stepCounter;
            }
            ProgressLink progressLink = new ProgressLink(null, stepCounter, progressBarText);
            progressLink.setFlowStepNumber(viewState.getStepNumber());
            progressLinks.add(progressLink);
        }
        return progressLinks;
    }

    private static Map<Integer, State> collectProgressStates(Flow flow) {
        boolean endStateFound = false;
        TreeMap<Integer, State> progressBarStateMap = new TreeMap<Integer, State>();
        String[] stateIds = null;
        if (flow != null) {
            stateIds = flow.getStateIds();
        }
        if (stateIds == null || stateIds.length == 0) {
            return progressBarStateMap;
        }
        for (int i = 0; i < stateIds.length; ++i) {
            State existingState;
            String newProgressBarText;
            Integer stepNumber;
            State state = flow.getStateInstance(stateIds[i]);
            if (state instanceof WicketViewState) {
                WicketViewState viewState = (WicketViewState)state;
                stepNumber = viewState.getStepNumber();
                newProgressBarText = viewState.getProgressBarText();
                if (Strings.isEmpty((CharSequence)newProgressBarText)) continue;
                if (progressBarStateMap.containsKey(stepNumber)) {
                    existingState = (State)progressBarStateMap.get(stepNumber);
                    if (existingState instanceof WicketEndState) {
                        LOG.error("A view State and a end state have been configured with the same step number: State ID:" + existingState.getId());
                        break;
                    }
                    String existingProgressBarText = ((WicketViewState)existingState).getProgressBarText();
                    if (!newProgressBarText.equals(existingProgressBarText)) {
                        LOG.error("Step Number {} has been configured with two different progress bar text", (Object)viewState.getStepNumber());
                        break;
                    }
                } else {
                    progressBarStateMap.put(viewState.getStepNumber(), (State)viewState);
                }
            }
            if (!(state instanceof WicketEndState)) continue;
            WicketEndState endState = (WicketEndState)state;
            stepNumber = endState.getStepNumber();
            newProgressBarText = endState.getProgressBarText();
            if (Strings.isEmpty((CharSequence)newProgressBarText)) {
                LOG.error("Progress Bar Text not specified for the End State : {}", (Object)endState.getId());
                continue;
            }
            if (!endStateFound) {
                if (progressBarStateMap.containsKey(stepNumber)) {
                    existingState = (State)progressBarStateMap.get(stepNumber);
                    if (!(existingState instanceof WicketViewState)) continue;
                    LOG.error("A view State and a end state have been configured with the same step number. State ID: {}", (Object)existingState.getId());
                    break;
                }
                progressBarStateMap.put(stepNumber, (State)endState);
                endStateFound = true;
                continue;
            }
            LOG.error("There are two end states configured for the flow {}", (Object)flow.getId());
            break;
        }
        return progressBarStateMap;
    }
}

