/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.webflow.controller;

import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.protocol.http.WebRequestCycleProcessor;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.wicketstuff.webflow.controller.RequestTargetFactory;
import org.wicketstuff.webflow.session.PageFlowSession;

public class PageFlowRequestCycleProcessor
extends WebRequestCycleProcessor {
    public IRequestTarget resolve(RequestCycle requestCycle, RequestParameters requestParameters) {
        String[] flowExecutionKeyParms;
        if (requestParameters.getParameters().containsKey("flowExecutionKey") && (flowExecutionKeyParms = (String[])requestParameters.getParameters().get("flowExecutionKey")).length > 0) {
            return RequestTargetFactory.buildFromState(flowExecutionKeyParms[0], requestCycle, requestParameters);
        }
        IRequestTarget target = super.resolve(requestCycle, requestParameters);
        if (target instanceof BookmarkablePageRequestTarget) {
            String currentStateFromSession = PageFlowSession.get().getFlowState().getCurrentViewState();
            return RequestTargetFactory.buildFromState(currentStateFromSession, requestCycle, requestParameters);
        }
        return target;
    }

    protected IRequestTarget resolveHomePageTarget(RequestCycle requestCycle, RequestParameters requestParameters) {
        BookmarkablePageRequestTarget classicTarget = (BookmarkablePageRequestTarget)super.resolveHomePageTarget(requestCycle, requestParameters);
        BookmarkablePageRequestTarget newTarget = this.resolvePageFlowTargets(classicTarget, requestCycle, requestParameters);
        if (!classicTarget.getPageClass().equals(newTarget.getPageClass())) {
            String currentStateFromSession = PageFlowSession.get().getFlowState().getCurrentViewState();
            if ("DONE".equals(currentStateFromSession)) {
                PageFlowSession.get().resetFlowState();
                classicTarget = (BookmarkablePageRequestTarget)super.resolveHomePageTarget(requestCycle, requestParameters);
                return classicTarget;
            }
            throw new RestartResponseException(newTarget.getPageClass(), newTarget.getPageParameters());
        }
        return this.resolvePageFlowTargets(classicTarget, requestCycle, requestParameters);
    }

    protected IRequestTarget resolveBookmarkablePage(RequestCycle requestCycle, RequestParameters requestParameters) {
        BookmarkablePageRequestTarget classicTarget = (BookmarkablePageRequestTarget)super.resolveBookmarkablePage(requestCycle, requestParameters);
        return this.resolvePageFlowTargets(classicTarget, requestCycle, requestParameters);
    }

    protected BookmarkablePageRequestTarget resolvePageFlowTargets(BookmarkablePageRequestTarget classicTarget, RequestCycle requestCycle, RequestParameters requestParameters) {
        BookmarkablePageRequestTarget target = null;
        String currentStateFromSession = PageFlowSession.get().getFlowState().getCurrentViewState();
        if (currentStateFromSession != null) {
            target = RequestTargetFactory.buildFromState(currentStateFromSession, requestCycle, requestParameters);
        }
        if (target == null) {
            target = classicTarget;
        }
        return target;
    }
}

