/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.webflow.controller;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.wicketstuff.webflow.FlowUtils;
import org.wicketstuff.webflow.controller.SpringWebFlowFacade;
import org.wicketstuff.webflow.session.FlowState;
import org.wicketstuff.webflow.session.PageFlowSession;

public class RequestTargetFactory {
    public static BookmarkablePageRequestTarget buildFromState(String flowExecutionKey, RequestCycle requestCycle, RequestParameters requestParameters) {
        FlowState<?> flowState = PageFlowSession.get().getFlowState();
        Class<? extends Component> viewStateClass = null;
        if ("DONE".equals(flowExecutionKey)) {
            viewStateClass = flowState.getFinalViewClass();
        } else {
            viewStateClass = new SpringWebFlowFacade().getViewStateClass(flowExecutionKey);
            if (viewStateClass != null) {
                flowState.setCurrentViewState(flowExecutionKey);
            }
        }
        if (viewStateClass == null) {
            viewStateClass = flowState.getLastRenderedViewClass();
            if ("DONE".equals(flowState.getCurrentViewState())) {
                FlowUtils.addFeedbackErrorBackDisallowed("RequestTargetFactory 46");
            } else {
                FlowUtils.addFeedbackErrorBadUrl("RequestTargetFactory 48");
            }
        }
        if (viewStateClass == null) {
            viewStateClass = Application.get().getHomePage();
        }
        flowState.setLastRenderedViewClass((Class<Component>)viewStateClass);
        flowState.setCurrentViewStepNumber(0, viewStateClass.getName());
        PageParameters pars = requestCycle.getPageParameters();
        if (pars == null) {
            pars = new PageParameters(requestParameters.getParameters());
        }
        pars.put("flowExecutionKey", (Object)PageFlowSession.get().getFlowState().getCurrentViewState());
        BookmarkablePageRequestTarget target = new BookmarkablePageRequestTarget((Class)viewStateClass, pars);
        return target;
    }

    public static BookmarkablePageRequestTarget buildFromTransition(String eventId, RequestCycle requestCycle) {
        FlowState<?> flowState = PageFlowSession.get().getFlowState();
        Class<? extends WebPage> nextPage = FlowUtils.getNextPage(eventId);
        PageParameters pars = requestCycle.getPageParameters();
        if (pars == null) {
            pars = new PageParameters();
        }
        pars.put("flowExecutionKey", (Object)flowState.getCurrentViewState());
        BookmarkablePageRequestTarget target = new BookmarkablePageRequestTarget(nextPage, pars);
        return target;
    }
}

