/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.webflow.controller;

import org.apache.wicket.Component;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.core.FlowException;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.NoMatchingTransitionException;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRestorationFailureException;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.FlowExecutorImpl;
import org.wicketstuff.webflow.IPageFlowContainer;
import org.wicketstuff.webflow.WicketSpringWebFlowException;
import org.wicketstuff.webflow.context.PageFlowExternalContext;
import org.wicketstuff.webflow.session.PageFlowSession;
import org.wicketstuff.webflow.view.WicketView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringWebFlowFacade {
    private static final Logger LOG = LoggerFactory.getLogger(SpringWebFlowFacade.class);
    FlowExecutor flowExecutor;
    PageFlowExternalContext context;

    public SpringWebFlowFacade(FlowExecutor flowExecutor, PageFlowExternalContext context) {
        this.flowExecutor = flowExecutor;
        this.context = context;
    }

    public SpringWebFlowFacade() {
        WebApplication application = WebApplication.get();
        PageFlowSession<?> pageFlowSession = PageFlowSession.get();
        if (!(application instanceof IPageFlowContainer)) {
            throw new WicketRuntimeException("Application must implement the interface " + IPageFlowContainer.class.getName());
        }
        this.flowExecutor = ((IPageFlowContainer)application).getFlowExecutor();
        this.context = new PageFlowExternalContext(application.getServletContext(), ((WebRequest)RequestCycle.get().getRequest()).getHttpServletRequest(), ((WebResponse)RequestCycle.get().getResponse()).getHttpServletResponse(), pageFlowSession);
    }

    public String launchWebFlowExecution(String flowId) {
        String launchedViewState = null;
        if (flowId != null) {
            try {
                FlowExecutionResult result = this.flowExecutor.launchExecution(flowId, null, (ExternalContext)this.context);
                launchedViewState = result.getPausedKey();
            }
            catch (FlowException flowException) {
                throw new WicketSpringWebFlowException("Unable to start flow", flowException);
            }
        }
        return launchedViewState;
    }

    public String resumeWebFlowExecution(String viewState) {
        String transitionedViewState = null;
        if (viewState != null) {
            try {
                FlowExecutionResult result = this.flowExecutor.resumeExecution(viewState, (ExternalContext)this.context);
                transitionedViewState = result.isEnded() ? "DONE" : result.getPausedKey();
            }
            catch (FlowExecutionRestorationFailureException flowException) {
                LOG.error("A Flow Exception occured in Spring Web Flow while resuming the application flow from the input view state" + viewState, (Throwable)flowException);
            }
            catch (NoMatchingTransitionException transitionEx) {
                throw new WicketSpringWebFlowException("Invalid view transition", transitionEx);
            }
            catch (FlowException flowException) {
                if (viewState.equals("DONE")) {
                    throw new WicketSpringWebFlowException("Flow completed. Unable to return to flow.", flowException);
                }
                throw new WicketSpringWebFlowException("Invalid view transition", flowException);
            }
        }
        return transitionedViewState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFlowExecutionKeyValid(String inputKey) {
        boolean isValid = false;
        ExternalContextHolder.setExternalContext((ExternalContext)this.context);
        FlowExecutionRepository repository = ((FlowExecutorImpl)this.flowExecutor).getExecutionRepository();
        try {
            FlowExecutionKey flowExecutionKey = repository.parseFlowExecutionKey(inputKey);
            FlowExecutionLock lock = repository.getLock(flowExecutionKey);
            if (lock != null) {
                isValid = true;
            }
        }
        catch (Exception exception) {
            LOG.debug("A Flow Exception occured in Spring Web Flow while determining whether the input flow execution key is valid: " + inputKey, (Throwable)exception);
        }
        finally {
            ExternalContextHolder.setExternalContext(null);
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<? extends Component> getViewStateClass(String inputFlowExecutionKey) {
        Class<? extends Component> viewStateClass = null;
        ExternalContextHolder.setExternalContext((ExternalContext)this.context);
        FlowExecutionRepository repository = ((FlowExecutorImpl)this.flowExecutor).getExecutionRepository();
        FlowExecutionKey flowExecutionKey = repository.parseFlowExecutionKey(inputFlowExecutionKey);
        try {
            FlowExecution flowExecution = repository.getFlowExecution(flowExecutionKey);
            ViewState viewState = (ViewState)flowExecution.getActiveSession().getState();
            viewStateClass = ((WicketView)viewState.getViewFactory().getView(null)).getViewId();
        }
        catch (FlowExecutionRestorationFailureException flowRestorationException) {
            LOG.error("A problem occurred restoring the flow execution with key '" + viewStateClass + "'", (Throwable)flowRestorationException);
        }
        catch (Exception exception) {
            LOG.error("An exception occurred while trying to retrieve the view state class for the input flow execution key from Spring Web Flow: " + flowExecutionKey, (Throwable)exception);
        }
        finally {
            ExternalContextHolder.setExternalContext(null);
        }
        return viewStateClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Flow getFlow(String inputFlowExecutionKey) {
        ExternalContextHolder.setExternalContext((ExternalContext)this.context);
        FlowExecutionRepository repository = ((FlowExecutorImpl)this.flowExecutor).getExecutionRepository();
        Flow flow = null;
        try {
            FlowExecutionKey flowExecutionKey = repository.parseFlowExecutionKey(inputFlowExecutionKey);
            FlowExecution flowExecution = repository.getFlowExecution(flowExecutionKey);
            ViewState viewState = (ViewState)flowExecution.getActiveSession().getState();
            flow = viewState.getFlow();
        }
        catch (Exception exception) {
            LOG.error("An exception occurred while trying to retrieve the view state class for the input flow execution key from Spring Web Flow " + inputFlowExecutionKey, (Throwable)exception);
        }
        finally {
            ExternalContextHolder.setExternalContext(null);
        }
        return flow;
    }
}

