/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.webflow.conversation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.impl.ConversationLock;
import org.wicketstuff.webflow.conversation.PageFlowConversationContainer;
import org.wicketstuff.webflow.session.PageFlowSession;

public class PageFlowContainedConversation
implements Conversation,
Serializable {
    private static final long serialVersionUID = 1L;
    private PageFlowConversationContainer container;
    private ConversationId id;
    private ConversationLock lock;
    private Map<Object, Object> attributes;

    public PageFlowContainedConversation(PageFlowConversationContainer container, ConversationId id, ConversationLock lock) {
        this.container = container;
        this.id = id;
        this.lock = lock;
        this.attributes = new HashMap<Object, Object>();
    }

    public ConversationId getId() {
        return this.id;
    }

    public void lock() {
        this.lock.lock();
    }

    public Object getAttribute(Object name) {
        return this.attributes.get(name);
    }

    public void putAttribute(Object name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(Object name) {
        this.attributes.remove(name);
    }

    public void end() {
        this.container.removeConversation(this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        PageFlowSession<?> pageFlowSession;
        this.lock.unlock();
        PageFlowSession<?> pageFlowSession2 = pageFlowSession = PageFlowSession.get();
        synchronized (pageFlowSession2) {
            pageFlowSession.getFlowState().setPageFlowConversationContainer(this.container);
        }
    }

    public String toString() {
        return this.getId().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PageFlowContainedConversation)) {
            return false;
        }
        return this.id.equals(((PageFlowContainedConversation)obj).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

