/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.webflow.conversation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.JdkVersion;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.ConversationParameters;
import org.springframework.webflow.conversation.NoSuchConversationException;
import org.springframework.webflow.conversation.impl.SimpleConversationId;
import org.wicketstuff.webflow.conversation.PageFlowContainedConversation;
import org.wicketstuff.webflow.conversation.PageFlowConversationLockFactory;

public class PageFlowConversationContainer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int maxConversations;
    private List<PageFlowContainedConversation> conversations;
    private int conversationIdSequence;

    public PageFlowConversationContainer(int maxConversations) {
        this.maxConversations = maxConversations;
        this.conversations = new ArrayList<PageFlowContainedConversation>();
    }

    public int size() {
        return this.conversations.size();
    }

    public synchronized Conversation createConversation(ConversationParameters parameters, PageFlowConversationLockFactory lockFactory) {
        PageFlowContainedConversation conversation = new PageFlowContainedConversation(this, this.nextId(), lockFactory.createLock());
        conversation.putAttribute("name", parameters.getName());
        conversation.putAttribute("caption", parameters.getCaption());
        conversation.putAttribute("description", parameters.getDescription());
        this.conversations.add(conversation);
        if (this.maxExceeded()) {
            ((Conversation)this.conversations.get(0)).end();
        }
        return conversation;
    }

    private ConversationId nextId() {
        if (JdkVersion.getMajorJavaVersion() == 2) {
            return new SimpleConversationId((Serializable)Integer.valueOf(++this.conversationIdSequence));
        }
        return new SimpleConversationId((Serializable)new Integer(++this.conversationIdSequence));
    }

    public synchronized Conversation getConversation(ConversationId id) throws NoSuchConversationException {
        for (PageFlowContainedConversation conversation : this.conversations) {
            if (!conversation.getId().equals(id)) continue;
            return conversation;
        }
        throw new NoSuchConversationException(id);
    }

    public synchronized void removeConversation(ConversationId id) {
        Iterator<PageFlowContainedConversation> it = this.conversations.iterator();
        while (it.hasNext()) {
            PageFlowContainedConversation conversation = it.next();
            if (!conversation.getId().equals(id)) continue;
            it.remove();
            break;
        }
    }

    private boolean maxExceeded() {
        return this.maxConversations > 0 && this.conversations.size() > this.maxConversations;
    }
}

