/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.webflow.conversation;

import java.io.Serializable;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationException;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.conversation.ConversationParameters;
import org.springframework.webflow.conversation.impl.BadlyFormattedConversationIdException;
import org.springframework.webflow.conversation.impl.SimpleConversationId;
import org.wicketstuff.webflow.conversation.PageFlowConversationContainer;
import org.wicketstuff.webflow.conversation.PageFlowConversationLockFactory;
import org.wicketstuff.webflow.session.PageFlowSession;

public class PageFlowConversationManager
implements ConversationManager {
    private int maxConversations = 5;
    private PageFlowConversationLockFactory conversationLockFactory = new PageFlowConversationLockFactory();

    public int getMaxConversations() {
        return this.maxConversations;
    }

    public void setMaxConversations(int maxConversations) {
        this.maxConversations = maxConversations;
    }

    public int getLockTimeoutSeconds() {
        return this.conversationLockFactory.getTimeoutSeconds();
    }

    public void setLockTimeoutSeconds(int timeoutSeconds) {
        this.conversationLockFactory.setTimeoutSeconds(timeoutSeconds);
    }

    public Conversation beginConversation(ConversationParameters conversationParameters) throws ConversationException {
        return this.getConversationContainer().createConversation(conversationParameters, this.conversationLockFactory);
    }

    public Conversation getConversation(ConversationId id) throws ConversationException {
        return this.getConversationContainer().getConversation(id);
    }

    public ConversationId parseConversationId(String encodedId) throws ConversationException {
        try {
            return new SimpleConversationId((Serializable)Integer.valueOf(encodedId));
        }
        catch (NumberFormatException e) {
            throw new BadlyFormattedConversationIdException(encodedId, (Throwable)e);
        }
    }

    public final PageFlowConversationContainer createConversationContainer() {
        return new PageFlowConversationContainer(this.maxConversations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PageFlowConversationContainer getConversationContainer() {
        PageFlowSession<?> pageFlowSession;
        PageFlowSession<?> pageFlowSession2 = pageFlowSession = PageFlowSession.get();
        synchronized (pageFlowSession2) {
            PageFlowConversationContainer container = pageFlowSession.getFlowState().getPageFlowConversationContainer();
            if (container == null) {
                container = this.createConversationContainer();
                pageFlowSession.getFlowState().setPageFlowConversationContainer(container);
            }
            return container;
        }
    }
}

