/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.webflow.session;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.wicketstuff.webflow.controller.PageFlowController;
import org.wicketstuff.webflow.conversation.PageFlowConversationContainer;
import org.wicketstuff.webflow.session.ProgressLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowState<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<StateCache> statesVisited = new ArrayList<StateCache>();
    private String startViewState;
    private String currentViewState;
    private String currentViewStateId;
    private int currentViewStepNumber;
    private Class<? extends Component> startViewClass;
    private Class<? extends Component> lastRenderedViewClass;
    private Class<? extends Component> finalViewClass;
    private PageFlowConversationContainer pageFlowConversationContainer;
    private boolean hasPageFlowErrorMessages = false;
    private List<ProgressLink> progressLinks;
    private IModel<T> model;

    public IModel<T> getModel() {
        return this.model;
    }

    public void setModel(IModel<T> model) {
        this.model = model;
    }

    public T getModelObject() {
        if (this.model != null) {
            return (T)this.model.getObject();
        }
        return null;
    }

    public void setModelObject(T object) {
        if (this.model == null) {
            throw new IllegalStateException("Attempt to set model object on null model of FlowState");
        }
        this.model.setObject(object);
    }

    public String getCurrentViewState() {
        return this.currentViewState;
    }

    public void setCurrentViewState(String currentViewState) {
        this.currentViewState = currentViewState;
    }

    public String getStartViewState() {
        return this.startViewState;
    }

    public void setStartViewState(String startViewState) {
        this.startViewState = startViewState;
    }

    public Class<? extends Component> getStartViewClass() {
        return this.startViewClass;
    }

    public void setStartViewClass(Class<? extends Component> startViewClass) {
        this.startViewClass = startViewClass;
    }

    public Class<? extends Component> getLastRenderedViewClass() {
        return this.lastRenderedViewClass;
    }

    public void setLastRenderedViewClass(Class<? extends Component> lastRenderedViewClass) {
        this.lastRenderedViewClass = lastRenderedViewClass;
    }

    public Class<? extends Component> getFinalViewClass() {
        return this.finalViewClass;
    }

    public void setFinalViewClass(Class<? extends Component> finalViewClass) {
        this.finalViewClass = finalViewClass;
    }

    public PageFlowConversationContainer getPageFlowConversationContainer() {
        return this.pageFlowConversationContainer;
    }

    public void setPageFlowConversationContainer(PageFlowConversationContainer pageFlowConversationContainer) {
        this.pageFlowConversationContainer = pageFlowConversationContainer;
    }

    public boolean hasPageFlowErrorMessages() {
        return this.hasPageFlowErrorMessages;
    }

    public void setHasPageFlowErrorMessages(boolean hasPageFlowErrorMessages) {
        this.hasPageFlowErrorMessages = hasPageFlowErrorMessages;
    }

    public List<ProgressLink> getProgressBarLinks() {
        if (this.progressLinks == null) {
            this.progressLinks = PageFlowController.populateProgressBarStates();
        }
        return this.progressLinks;
    }

    public void setCurrentViewStepNumber(int stepNumberInput, String stateId) {
        int stepNumber = 0;
        stepNumber = stepNumberInput != 0 ? stepNumberInput : this.getStepNumberForStateId(stateId);
        this.currentViewStepNumber = stepNumber;
    }

    private int getStepNumberForStateId(String stateId) {
        for (StateCache state : this.statesVisited) {
            if (!state.id.equals(stateId)) continue;
            return state.progressLinksStepNumber;
        }
        StateCache newState = new StateCache();
        newState.id = stateId;
        newState.progressLinksStepNumber = this.currentViewStepNumber;
        this.statesVisited.add(newState);
        return newState.progressLinksStepNumber;
    }

    public String getCurrentViewStateId() {
        return this.currentViewStateId;
    }

    public void setCurrentViewStateId(String transitionedViewStateId) {
        this.currentViewStateId = transitionedViewStateId;
    }

    private class StateCache
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String id;
        public int progressLinksStepNumber;

        private StateCache() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StateType {
        VIEWSTATE,
        ENDSTATE;

    }
}

