/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.webflow.state;

import org.springframework.core.style.StylerUtils;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.NoMatchingTransitionException;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ActionExecutor;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.RequestContext;

public class WicketActionState
extends ActionState {
    public WicketActionState(Flow flow, String id) throws IllegalArgumentException {
        super(flow, id);
    }

    protected void doEnter(RequestControlContext context) throws FlowExecutionException {
        int executionCount = 0;
        String[] eventIds = new String[this.getActionList().size()];
        for (Action action : this.getActionList()) {
            Event event = ActionExecutor.execute((Action)action, (RequestContext)context);
            if (event != null) {
                eventIds[executionCount] = event.getId();
                try {
                    context.handleEvent(event);
                    return;
                }
                catch (NoMatchingActionResultTransitionException e) {
                    try {
                        Event event1 = new Event(event.getSource(), "DEFAULT");
                        context.handleEvent(event1);
                        return;
                    }
                    catch (NoMatchingActionResultTransitionException e1) {}
                }
            } else {
                eventIds[executionCount] = null;
            }
            ++executionCount;
        }
        if (executionCount > 0) {
            throw new NoMatchingTransitionException(this.getFlow().getId(), this.getId(), context.getCurrentEvent(), "No transition was matched on the event(s) signaled by the [" + executionCount + "] action(s) that executed in this action state '" + this.getId() + "' of flow '" + this.getFlow().getId() + "'; transitions must be defined to handle action result outcomes -- " + "possible flow configuration error? Note: the eventIds signaled were: '" + StylerUtils.style((Object)eventIds) + "', while the supported set of transitional criteria for this action state is '" + StylerUtils.style((Object)this.getTransitionSet().getTransitionCriterias()) + "'");
        }
        throw new IllegalStateException("No actions were executed, thus I cannot execute any state transition -- programmer configuration error; make sure you add at least one action to this state's action list");
    }

    public Transition getRequiredTransition(RequestContext context) throws NoMatchingTransitionException {
        Transition transition = this.getTransitionSet().getTransition(context);
        if (transition == null) {
            throw new NoMatchingActionResultTransitionException(this, context.getCurrentEvent());
        }
        return transition;
    }

    private static class NoMatchingActionResultTransitionException
    extends NoMatchingTransitionException {
        private static final long serialVersionUID = 1L;

        public NoMatchingActionResultTransitionException(ActionState state, Event resultEvent) {
            super(state.getFlow().getId(), state.getId(), resultEvent, "Cannot find a transition matching an action result event; continuing with next action...");
        }
    }
}

