/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.webflow.view;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.mapping.Mapper;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowExecutionExceptionHandler;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewVariable;
import org.springframework.webflow.engine.builder.FlowArtifactFactory;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ViewFactory;
import org.wicketstuff.webflow.state.WicketActionState;
import org.wicketstuff.webflow.state.WicketEndState;
import org.wicketstuff.webflow.state.WicketViewState;

public class WicketFlowArtifactFactory
extends FlowArtifactFactory {
    private static final Logger LOG = LoggerFactory.getLogger(WicketFlowArtifactFactory.class);

    public State createActionState(String id, Flow flow, Action[] entryActions, Action[] actions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) {
        WicketActionState actionState = new WicketActionState(flow, id);
        actionState.getActionList().addAll(actions);
        this.configureCommonProperties((TransitionableState)actionState, entryActions, transitions, exceptionHandlers, exitActions, attributes);
        return actionState;
    }

    public State createViewState(String id, Flow flow, ViewVariable[] variables, Action[] entryActions, ViewFactory viewFactory, Boolean redirect, boolean popup, Action[] renderActions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) {
        String progressBarText = this.getStepText(attributes);
        Integer stepNumber = this.getStepNumber(id, attributes);
        WicketViewState viewState = new WicketViewState(flow, id, viewFactory, progressBarText, stepNumber);
        viewState.addVariables(variables);
        viewState.setRedirect(redirect);
        viewState.setPopup(popup);
        viewState.getRenderActionList().addAll(renderActions);
        this.configureCommonProperties((TransitionableState)viewState, entryActions, transitions, exceptionHandlers, exitActions, attributes);
        return viewState;
    }

    public State createEndState(String id, Flow flow, Action[] entryActions, Action finalResponseAction, Mapper outputMapper, FlowExecutionExceptionHandler[] exceptionHandlers, AttributeMap attributes) {
        String progressBarText = this.getStepText(attributes);
        Integer stepNumber = this.getStepNumber(id, attributes);
        WicketEndState endState = new WicketEndState(flow, id, progressBarText, stepNumber);
        if (finalResponseAction != null) {
            endState.setFinalResponseAction(finalResponseAction);
        }
        if (outputMapper != null) {
            endState.setOutputMapper(outputMapper);
        }
        this.configureCommonProperties((State)endState, entryActions, exceptionHandlers, attributes);
        return endState;
    }

    private String getStepText(AttributeMap attributes) {
        return attributes.getString("progressBarText");
    }

    private Integer getStepNumber(String id, AttributeMap attributes) {
        Integer stepNumber = 0;
        try {
            String stepNumberInput = attributes.getString("stepNumber", "0");
            stepNumber = Integer.valueOf(stepNumberInput);
        }
        catch (NumberFormatException e) {
            LOG.warn("Step number for Flow step " + id + " isn't an integer. Value was: " + e.getMessage());
            stepNumber = 0;
        }
        return stepNumber;
    }

    private void configureCommonProperties(TransitionableState state, Action[] entryActions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) {
        this.configureCommonProperties((State)state, entryActions, exceptionHandlers, attributes);
        state.getTransitionSet().addAll(transitions);
        state.getExitActionList().addAll(exitActions);
    }

    private void configureCommonProperties(State state, Action[] entryActions, FlowExecutionExceptionHandler[] exceptionHandlers, AttributeMap attributes) {
        state.getEntryActionList().addAll(entryActions);
        state.getExceptionHandlerSet().addAll(exceptionHandlers);
        state.getAttributes().putAll(attributes);
    }
}

