/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.webflow.view;

import java.io.IOException;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.wicketstuff.webflow.context.PageFlowSharedContext;
import org.wicketstuff.webflow.context.PageFlowSharedContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WicketView
implements View {
    private RequestContext requestContext;
    private Class<? extends Component> viewId;
    private String eventId;
    private boolean userEventProcessed;

    public WicketView(RequestContext requestContext, Class<? extends Component> viewId) {
        this.requestContext = requestContext;
        this.viewId = viewId;
    }

    public void render() throws IOException {
        PageFlowSharedContextHolder.getSharedContext().setRenderedViewStateClass(this.viewId);
    }

    public Serializable getUserEventState() {
        return null;
    }

    public boolean hasFlowEvent() {
        return this.userEventProcessed;
    }

    public void processUserEvent() {
        String eventId = this.getEventId();
        if (eventId == null) {
            return;
        }
        this.userEventProcessed = true;
    }

    public Event getFlowEvent() {
        return new Event((Object)this, this.getEventId());
    }

    public void saveState() {
    }

    public boolean userEventQueued() {
        return !this.userEventProcessed && this.getEventId() != null;
    }

    protected String getEventId() {
        if (this.eventId == null) {
            PageFlowSharedContext context = PageFlowSharedContextHolder.getSharedContext();
            this.eventId = context.getEventId();
        }
        return this.eventId;
    }

    public Class<? extends Component> getViewId() {
        return this.viewId;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }
}

