/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.webflow.view;

import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.validation.Validator;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.ViewFactoryCreator;
import org.springframework.webflow.execution.ViewFactory;
import org.wicketstuff.webflow.view.WicketViewFactory;

public class WicketViewFactoryCreator
implements ViewFactoryCreator {
    private static final Logger LOG = LoggerFactory.getLogger(WicketViewFactoryCreator.class);

    public ViewFactory createViewFactory(Expression viewId, ExpressionParser expressionParser, ConversionService conversionService, BinderConfiguration binderConfiguration, Validator validator) {
        Class<?> viewClass;
        try {
            Class<?> parsedClass = Class.forName(viewId.toString());
            if (!Component.class.isAssignableFrom(parsedClass)) {
                throw new WicketRuntimeException("Component " + viewId.toString() + " must implement the class " + Component.class.getName() + " for it to be used in a WebFlow.");
            }
            viewClass = parsedClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.error("An exception occurred while trying to load the view state class retrieved from Spring Web Flow " + viewId.toString(), (Throwable)classNotFoundException);
            throw new RuntimeException(classNotFoundException);
        }
        return new WicketViewFactory(viewClass);
    }

    public String getViewIdByConvention(String viewStateId) {
        return viewStateId;
    }
}

