/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.html5.geolocation;

import java.util.HashMap;
import org.apache.wicket.Component;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.apache.wicket.util.template.PackagedTextTemplate;

public abstract class AjaxGeolocationBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static PackagedTextTemplate GEOLOCATION_TMPL_JS = new PackagedTextTemplate(AjaxGeolocationBehavior.class, "geolocation.js", "application/javascript", "UTF-8");

    protected void respond(AjaxRequestTarget target) {
        Request request = RequestCycle.get().getRequest();
        String latitude = request.getParameter("lat");
        String longitude = request.getParameter("long");
        this.onGeoAvailable(target, latitude, longitude);
    }

    protected abstract void onGeoAvailable(AjaxRequestTarget var1, String var2, String var3);

    protected void onBind() {
        super.onBind();
        Component component = this.getComponent();
        component.setOutputMarkupId(true);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        CharSequence callbackUrl = this.getCallbackUrl(false);
        String componentMarkupId = this.getComponent().getMarkupId();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("componentId", componentMarkupId);
        variables.put("callbackUrl", ((Object)callbackUrl).toString());
        String javascript = MapVariableInterpolator.interpolate((String)GEOLOCATION_TMPL_JS.asString(), variables);
        response.renderOnDomReadyJavascript(javascript);
    }
}

