/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.html5.markup.html.form;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;

public class RangeTextField
extends TextField<Double> {
    private static final long serialVersionUID = 1L;
    private Double minimum;
    private Double maximum;
    private Double step;

    public RangeTextField(String id) {
        this(id, null);
    }

    public RangeTextField(String id, IModel<Double> model) {
        super(id, model);
        this.setRequired(true);
        this.setType(Double.class);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.minimum != null) {
            tag.put("min", (CharSequence)this.minimum.toString());
        }
        if (this.maximum != null) {
            tag.put("max", (CharSequence)this.maximum.toString());
        }
        if (this.step != null) {
            tag.put("step", (CharSequence)this.step.toString());
        }
    }

    protected String getInputType() {
        return "range";
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public Double getStep() {
        return this.step;
    }

    public void setMinimum(Double minimum) {
        this.minimum = minimum;
    }

    public void setMaximum(Double maximum) {
        this.maximum = maximum;
    }

    public void setStep(Double step) {
        this.step = step;
    }
}

