/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.html5.media;

import java.util.List;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.wicketstuff.html5.Html5UtilsBehavior;
import org.wicketstuff.html5.media.MediaSource;

public class Html5Media
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private IModel<List<MediaSource>> sources;

    public Html5Media(String id, IModel<List<MediaSource>> model) {
        super(id, model);
        this.sources = this.wrap(model);
        this.add(new IBehavior[]{new Html5UtilsBehavior()});
    }

    public List<MediaSource> getSources() {
        List sources;
        List list = sources = this.sources != null ? (List)this.sources.getObject() : null;
        if (sources == null) {
            throw new NullPointerException("List of sources is null - Was the supplied 'Sources' model empty?");
        }
        return sources;
    }

    public void renderHead(HtmlHeaderContainer container) {
        super.renderHead(container);
    }

    protected boolean isAutoBuffer() {
        return false;
    }

    protected boolean isAutoPlay() {
        return false;
    }

    protected boolean isLoop() {
        return false;
    }

    protected boolean isControls() {
        return false;
    }

    protected void onComponentTag(ComponentTag tag) {
        List<MediaSource> sources;
        String tagName = this.getTagName();
        if (tagName != null) {
            this.checkComponentTag(tag, tagName);
        }
        if ((sources = this.getSources()) != null && sources.size() == 1) {
            MediaSource source = sources.get(0);
            tag.put("src", (CharSequence)source.getSrc());
        }
        if (this.isAutoBuffer()) {
            tag.put("autobuffer", true);
        }
        if (this.isAutoPlay()) {
            tag.put("autoplay", true);
        }
        if (this.isLoop()) {
            tag.put("loop", true);
        }
        if (this.isControls()) {
            tag.put("controls", true);
        }
        super.onComponentTag(tag);
    }

    protected String getTagName() {
        return null;
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        List<MediaSource> sources = this.getSources();
        if (sources != null && sources.size() > 1) {
            AppendingStringBuffer buffer = new AppendingStringBuffer();
            for (int index = 0; index < sources.size(); ++index) {
                MediaSource source = sources.get(index);
                buffer.append("\n<source ");
                buffer.append("src='");
                buffer.append(source.getSrc());
                buffer.append("'");
                if (source.getType() != null) {
                    buffer.append(" type='");
                    buffer.append(source.getType());
                    buffer.append("'");
                }
                if (source.getMedia() != null) {
                    buffer.append(" media='");
                    buffer.append(source.getMedia());
                    buffer.append("'");
                }
                buffer.append(" />");
            }
            buffer.append("\n");
            this.getResponse().write((CharSequence)buffer.toString());
        }
        super.onComponentTagBody(markupStream, openTag);
    }
}

