/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wicket.mount.processor;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.wicketstuff.wicket.mount.annotation.AutoMount;
import org.wicketstuff.wicket.mount.core.annotation.MountPath;
import org.wicketstuff.wicket.mount.core.processor.AbstractAutoMountAnnotationProcessor;
import org.wicketstuff.wicket.mount.core.processor.AutoMountContext;

@SupportedAnnotationTypes(value={"org.wicketstuff.wicket.mount.annotation.AutoMount", "org.wicketstuff.wicket.mount.core.annotation.MountPath"})
public class AutoMountAnnotationProcessor
extends AbstractAutoMountAnnotationProcessor {
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            for (Element element : roundEnv.getElementsAnnotatedWith(AutoMount.class)) {
                AutoMountContext context = this.getAutoMountContext(element, AutoMount.class);
                if (context == null) continue;
                for (Element element2 : roundEnv.getElementsAnnotatedWith(MountPath.class)) {
                    MountPath mp = element2.getAnnotation(MountPath.class);
                    this.processMountPoint(context, element2, (Annotation)mp);
                }
                this.generateSource(context);
            }
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(AutoMountAnnotationProcessor.class.getName()).log(Level.SEVERE, null, ex);
            return true;
        }
    }

    protected void setPackagesToScan(AutoMountContext context) {
        AutoMount annotation = (AutoMount)context.getAppAnnotation(AutoMount.class);
        String[] packagesToScan = annotation != null ? annotation.packagesToScan() : new String[]{};
        if (packagesToScan.length == 0) {
            context.addPackageToScan(context.getApplicationPackage().getQualifiedName().toString() + ".*");
        } else {
            context.addPackagesToScan(packagesToScan);
        }
    }

    protected String getDefaultRootPath(AutoMountContext context, TypeElement elem) {
        AutoMount annotation = (AutoMount)context.getAppAnnotation(AutoMount.class);
        if (annotation != null) {
            return annotation.defaultRoot().replaceAll("^/+|/+$", "");
        }
        return "";
    }

    protected String getDefaultMimeExtension(AutoMountContext context, TypeElement elem) {
        String mimeExtension = "";
        AutoMount annotation = (AutoMount)context.getAppAnnotation(AutoMount.class);
        if (annotation != null) {
            mimeExtension = annotation.mimeExtension();
        }
        if (!mimeExtension.isEmpty() && !mimeExtension.startsWith(".")) {
            mimeExtension = "." + mimeExtension;
        }
        return mimeExtension;
    }
}

