/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.osgi.test.library.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.wicketstuff.osgi.test.library.model.Author;
import org.wicketstuff.osgi.test.library.model.Book;
import org.wicketstuff.osgi.test.library.service.LibraryService;

public class SimpleLibraryService
implements LibraryService {
    private static final long serialVersionUID = 1L;
    private int authorId;
    private int bookId;
    private Map<Integer, Author> authors = new TreeMap<Integer, Author>();
    private Map<Integer, Book> books = new TreeMap<Integer, Book>();

    @Override
    public void fillLibrary() {
        if (this.getNumBooks() != 0L) {
            return;
        }
        Author mann = new Author();
        mann.setFirstName("Thomas");
        mann.setLastName("Mann");
        Author steinbeck = new Author();
        steinbeck.setFirstName("John");
        steinbeck.setLastName("Steinbeck");
        Book buddenbrooks = new Book();
        buddenbrooks.setTitle("Buddenbrooks");
        buddenbrooks.setAuthor(mann);
        mann.getBooks().add(buddenbrooks);
        Book eden = new Book();
        eden.setTitle("East of Eden");
        eden.setAuthor(steinbeck);
        steinbeck.getBooks().add(eden);
        this.save(mann);
        this.save(steinbeck);
        this.save(buddenbrooks);
        this.save(eden);
    }

    private void save(Author author) {
        author.setId(++this.authorId);
        this.authors.put(author.getId(), author);
    }

    private void save(Book book) {
        book.setId(++this.bookId);
        this.books.put(book.getId(), book);
    }

    @Override
    public List<Book> findBooksByAuthor(String lastName) {
        ArrayList<Book> results = new ArrayList<Book>();
        for (Book book : this.books.values()) {
            if (!lastName.equals(book.getAuthor().getLastName())) continue;
            results.add(book);
        }
        return results;
    }

    @Override
    public List<Book> findBooksByTitle(String title) {
        ArrayList<Book> results = new ArrayList<Book>();
        for (Book book : this.books.values()) {
            if (!title.equals(book.getTitle())) continue;
            results.add(book);
        }
        return results;
    }

    @Override
    public long getNumBooks() {
        return this.books.size();
    }

    @Override
    public long getNumAuthors() {
        return this.authors.size();
    }

    @Override
    public void createAuthor(Author author) {
        this.save(author);
    }
}

